/*
 * Decompiled with CFR 0.152.
 */
package org.tools4j.elara.log;

import org.tools4j.elara.log.IndexTrackingPoller;
import org.tools4j.elara.log.MessageLog;

public class DefaultIndexTrackingPoller
implements IndexTrackingPoller {
    private final MessageLog.Poller poller;
    private long index;

    public DefaultIndexTrackingPoller(MessageLog messageLog) {
        this.poller = messageLog.poller();
        this.moveToStart();
    }

    @Override
    public long index() {
        return this.index;
    }

    @Override
    public long entryId() {
        return this.poller.entryId();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public boolean moveTo(long entryId) {
        if (this.poller.entryId() == entryId) {
            return true;
        }
        long originalEntryId = this.poller.entryId();
        boolean found = false;
        try {
            this.poller.moveToStart();
            long index = 0L;
            while (this.poller.entryId() != entryId && this.poller.poll(message -> MessageLog.Handler.Result.POLL) != 0) {
                ++index;
            }
            if (this.poller.entryId() == entryId) {
                this.index = index;
                found = true;
            }
        }
        finally {
            if (!found) {
                this.poller.moveTo(originalEntryId);
            }
        }
        return found;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public boolean moveToIndex(long index) {
        if (this.index() == index) {
            return true;
        }
        long originalEntryId = this.poller.entryId();
        boolean found = false;
        try {
            long pollIndex;
            this.poller.moveToStart();
            for (pollIndex = 0L; pollIndex != index && this.poller.poll(message -> MessageLog.Handler.Result.POLL) != 0; ++pollIndex) {
            }
            if (pollIndex == index) {
                this.index = pollIndex;
                found = true;
            }
        }
        finally {
            if (!found) {
                this.poller.moveTo(originalEntryId);
            }
        }
        return found;
    }

    @Override
    public boolean moveToNext() {
        if (this.poller.moveToNext()) {
            ++this.index;
            return true;
        }
        return false;
    }

    @Override
    public boolean moveToPrevious() {
        if (this.index > 0L && this.poller.moveToPrevious()) {
            --this.index;
            return true;
        }
        return false;
    }

    @Override
    public DefaultIndexTrackingPoller moveToStart() {
        this.poller.moveToStart();
        this.index = 0L;
        return this;
    }

    @Override
    public MessageLog.Poller moveToEnd() {
        while (this.poller.moveToNext()) {
            ++this.index;
        }
        return this;
    }

    @Override
    public int poll(MessageLog.Handler handler) {
        int polled = this.poller.poll(handler);
        if (polled > 0) {
            assert (polled == 1);
            ++this.index;
            return 1;
        }
        return 0;
    }
}

