/*
 * Decompiled with CFR 0.152.
 */
package org.tools4j.elara.init;

import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.function.Consumer;
import java.util.function.Supplier;
import java.util.stream.Collectors;
import org.agrona.collections.Object2ObjectHashMap;
import org.tools4j.elara.init.Configuration;
import org.tools4j.elara.plugin.api.Plugin;

final class PluginContext {
    private static final PluginBuilder<?> DEFAULT_BUILDER = PluginContext.defaultBuilder();
    private final Map<Plugin<?>, PluginBuilder<?>> pluginBuilders = new Object2ObjectHashMap();
    private final Map<Plugin<?>, Consumer<?>> pluginStateAwares = new Object2ObjectHashMap();

    PluginContext() {
    }

    void register(Plugin<?> plugin) {
        this.register(plugin, Plugin.STATE_UNAWARE);
    }

    <P> void register(Plugin<P> plugin, Supplier<? extends P> pluginStateProvider) {
        this.register(plugin, pluginStateProvider, Plugin.STATE_UNAWARE);
    }

    <P> void register(Plugin<P> plugin, Consumer<? super P> pluginStateAware) {
        this.register(plugin, PluginContext.defaultBuilder(), pluginStateAware);
    }

    <P> void register(Plugin<P> plugin, Supplier<? extends P> pluginStateProvider, Consumer<? super P> pluginStateAware) {
        this.register(plugin, PluginContext.builder(plugin, pluginStateProvider), pluginStateAware);
    }

    private <P> void register(Plugin<P> plugin, PluginBuilder<P> builder, Consumer<? super P> pluginStateAware) {
        PluginBuilder<?> curBuilder = this.pluginBuilders.get(plugin);
        if (curBuilder == null || curBuilder == DEFAULT_BUILDER) {
            this.pluginBuilders.put(plugin, builder);
        } else if (builder != curBuilder) {
            throw new IllegalStateException("plugin " + plugin + " is already registered with a different state provider");
        }
        if (pluginStateAware != Plugin.STATE_UNAWARE) {
            Consumer<Object> consumer = this.pluginStateAwares.getOrDefault(plugin, Plugin.STATE_UNAWARE);
            this.pluginStateAwares.put(plugin, consumer.andThen(pluginStateAware));
        }
        if (curBuilder == null) {
            for (Plugin.Dependency<?> dependency : plugin.dependencies()) {
                this.register(dependency);
            }
        }
    }

    private <P> void register(Plugin.Dependency<P> dependency) {
        this.register(dependency.plugin(), dependency.pluginStateAware());
    }

    private static <P> Plugin.Configuration build(Plugin<P> plugin, Configuration appConfig, Consumer<? super P> pluginStateAware) {
        P pluginState = plugin.defaultPluginState();
        pluginStateAware.accept(pluginState);
        return plugin.configuration(appConfig, pluginState);
    }

    private static <P> PluginBuilder<P> defaultBuilder() {
        PluginBuilder builder = PluginContext::build;
        assert (builder == DEFAULT_BUILDER || DEFAULT_BUILDER == null);
        return builder;
    }

    private static <P> PluginBuilder<P> builder(Plugin<P> plugin, Supplier<? extends P> pluginStateProvider) {
        Objects.requireNonNull(plugin);
        Objects.requireNonNull(pluginStateProvider);
        return (p, c, a) -> {
            assert (p == plugin);
            Object pluginState = pluginStateProvider.get();
            a.accept(pluginState);
            return plugin.configuration(c, pluginState);
        };
    }

    private <P> Plugin.Configuration configuration(Plugin<P> plugin, Configuration appConfig, PluginBuilder<?> builder) {
        PluginBuilder<?> pluginBuilder = builder;
        Consumer<Object> pluginStateAware = this.pluginStateAwares.getOrDefault(plugin, Plugin.STATE_UNAWARE);
        return pluginBuilder.build(plugin, appConfig, pluginStateAware);
    }

    List<Plugin.Configuration> configurations(Configuration appConfig) {
        Objects.requireNonNull(appConfig);
        return this.pluginBuilders.entrySet().stream().map(e -> this.configuration((Plugin)e.getKey(), appConfig, (PluginBuilder)e.getValue())).collect(Collectors.toList());
    }

    private static interface PluginBuilder<P> {
        public Plugin.Configuration build(Plugin<P> var1, Configuration var2, Consumer<? super P> var3);
    }
}

