/*
 * Decompiled with CFR 0.152.
 */
package org.tools4j.elara.init;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.EnumMap;
import java.util.List;
import java.util.Objects;
import java.util.concurrent.ThreadFactory;
import java.util.concurrent.TimeUnit;
import java.util.function.Consumer;
import java.util.function.Supplier;
import org.agrona.concurrent.BackoffIdleStrategy;
import org.agrona.concurrent.IdleStrategy;
import org.tools4j.elara.application.CommandProcessor;
import org.tools4j.elara.application.DuplicateHandler;
import org.tools4j.elara.application.EventApplier;
import org.tools4j.elara.application.ExceptionHandler;
import org.tools4j.elara.init.CommandLogMode;
import org.tools4j.elara.init.Configuration;
import org.tools4j.elara.init.Context;
import org.tools4j.elara.init.ExecutionType;
import org.tools4j.elara.init.PluginContext;
import org.tools4j.elara.input.Input;
import org.tools4j.elara.log.MessageLog;
import org.tools4j.elara.logging.Logger;
import org.tools4j.elara.logging.OutputStreamLogger;
import org.tools4j.elara.output.Output;
import org.tools4j.elara.plugin.api.Plugin;
import org.tools4j.elara.time.TimeSource;
import org.tools4j.nobark.loop.Step;

final class DefaultContext
implements Context {
    private static final String DEFAULT_THREAD_NAME = "elara";
    private CommandProcessor commandProcessor;
    private EventApplier eventApplier;
    private final List<Input> inputs = new ArrayList<Input>();
    private Output output = Output.NOOP;
    private MessageLog commandLog;
    private CommandLogMode commandLogMode = CommandLogMode.FROM_END;
    private MessageLog eventLog;
    private TimeSource timeSource;
    private ExceptionHandler exceptionHandler = ExceptionHandler.DEFAULT;
    private Logger.Factory loggerFactory = OutputStreamLogger.SYSTEM_FACTORY;
    private DuplicateHandler duplicateHandler = DuplicateHandler.DEFAULT;
    private IdleStrategy idleStrategy = new BackoffIdleStrategy(100L, 10L, TimeUnit.MICROSECONDS.toNanos(1L), TimeUnit.MICROSECONDS.toNanos(100L));
    private final EnumMap<ExecutionType, List<Step>> extraSteps = new EnumMap(ExecutionType.class);
    private ThreadFactory threadFactory;
    private final PluginContext plugins = new PluginContext();

    DefaultContext() {
    }

    @Override
    public CommandProcessor commandProcessor() {
        return this.commandProcessor;
    }

    @Override
    public Context commandProcessor(CommandProcessor commandProcessor) {
        this.commandProcessor = Objects.requireNonNull(commandProcessor);
        return this;
    }

    @Override
    public EventApplier eventApplier() {
        return this.eventApplier;
    }

    @Override
    public Context eventApplier(EventApplier eventApplier) {
        this.eventApplier = Objects.requireNonNull(eventApplier);
        return this;
    }

    @Override
    public List<Input> inputs() {
        return this.inputs;
    }

    @Override
    public Context input(Input input) {
        this.inputs.add(input);
        return this;
    }

    @Override
    public Context inputs(Input ... inputs) {
        for (Input input : inputs) {
            this.input(input);
        }
        return this;
    }

    @Override
    public Context inputs(Collection<? extends Input> inputs) {
        this.inputs.addAll(inputs);
        return this;
    }

    @Override
    public Output output() {
        return this.output;
    }

    @Override
    public Context output(Output output) {
        this.output = Objects.requireNonNull(output);
        return this;
    }

    @Override
    public MessageLog commandLog() {
        return this.commandLog;
    }

    @Override
    public Context commandLog(String file) {
        throw new IllegalStateException("not supported yet");
    }

    @Override
    public Context commandLog(MessageLog commandLog) {
        this.commandLog = Objects.requireNonNull(commandLog);
        return this;
    }

    @Override
    public CommandLogMode commandLogMode() {
        return this.commandLogMode;
    }

    @Override
    public Context commandLogMode(CommandLogMode mode) {
        this.commandLogMode = Objects.requireNonNull(mode);
        return this;
    }

    @Override
    public MessageLog eventLog() {
        return this.eventLog;
    }

    @Override
    public Context eventLog(String file) {
        throw new IllegalStateException("not supported yet");
    }

    @Override
    public Context eventLog(MessageLog eventLog) {
        this.eventLog = Objects.requireNonNull(eventLog);
        return this;
    }

    @Override
    public TimeSource timeSource() {
        return this.timeSource;
    }

    @Override
    public Context timeSource(TimeSource timeSource) {
        this.timeSource = timeSource;
        return this;
    }

    @Override
    public ExceptionHandler exceptionHandler() {
        return this.exceptionHandler;
    }

    @Override
    public Context exceptionHandler(ExceptionHandler exceptionHandler) {
        this.exceptionHandler = Objects.requireNonNull(exceptionHandler);
        return this;
    }

    @Override
    public DuplicateHandler duplicateHandler() {
        return this.duplicateHandler;
    }

    @Override
    public Context duplicateHandler(DuplicateHandler duplicateHandler) {
        this.duplicateHandler = Objects.requireNonNull(duplicateHandler);
        return this;
    }

    @Override
    public Logger.Factory loggerFactory() {
        return this.loggerFactory;
    }

    @Override
    public Context loggerFactory(Logger.Factory loggerFactory) {
        this.loggerFactory = Objects.requireNonNull(loggerFactory);
        if (this.duplicateHandler == DuplicateHandler.DEFAULT && loggerFactory != OutputStreamLogger.SYSTEM_FACTORY) {
            this.duplicateHandler = DuplicateHandler.loggingHandler(loggerFactory);
        }
        return this;
    }

    @Override
    public IdleStrategy idleStrategy() {
        return this.idleStrategy;
    }

    @Override
    public Context idleStrategy(IdleStrategy idleStrategy) {
        this.idleStrategy = Objects.requireNonNull(idleStrategy);
        return this;
    }

    @Override
    public List<Step> dutyCycleExtraSteps(ExecutionType executionType) {
        return this.extraSteps.getOrDefault((Object)executionType, Collections.emptyList());
    }

    @Override
    public Context dutyCycleExtraStep(Step step, ExecutionType executionType) {
        Objects.requireNonNull(step);
        Objects.requireNonNull(executionType);
        this.extraSteps.computeIfAbsent(executionType, k -> new ArrayList()).add(step);
        return this;
    }

    @Override
    public ThreadFactory threadFactory() {
        return this.threadFactory;
    }

    @Override
    public Context threadFactory(ThreadFactory threadFactory) {
        this.threadFactory = threadFactory;
        return this;
    }

    @Override
    public Context threadFactory(String threadName) {
        return this.threadFactory(threadName == null ? null : r -> new Thread(null, r, threadName));
    }

    @Override
    public Context plugin(Plugin<?> plugin) {
        this.plugins.register(plugin);
        return this;
    }

    @Override
    public <P> Context plugin(Plugin<P> plugin, Supplier<? extends P> pluginStateProvider) {
        this.plugins.register(plugin, pluginStateProvider);
        return this;
    }

    @Override
    public <P> Context plugin(Plugin<P> plugin, Consumer<? super P> pluginStateAware) {
        this.plugins.register(plugin, pluginStateAware);
        return this;
    }

    @Override
    public <P> Context plugin(Plugin<P> plugin, Supplier<? extends P> pluginStateProvider, Consumer<? super P> pluginStateAware) {
        this.plugins.register(plugin, pluginStateProvider, pluginStateAware);
        return this;
    }

    @Override
    public List<Plugin.Configuration> plugins() {
        return this.plugins.configurations(this);
    }

    @Override
    public Context populateDefaults() {
        if (this.timeSource == null) {
            this.timeSource = System::currentTimeMillis;
        }
        if (this.threadFactory == null) {
            this.threadFactory(DEFAULT_THREAD_NAME);
        }
        return this;
    }

    static Configuration validate(Configuration configuration) {
        if (configuration.commandProcessor() == null) {
            throw new IllegalArgumentException("Command processor must be set");
        }
        if (configuration.eventApplier() == null) {
            throw new IllegalArgumentException("Event applier must be set");
        }
        if (configuration.commandLog() == null) {
            throw new IllegalArgumentException("Command log must be set");
        }
        if (configuration.eventLog() == null) {
            throw new IllegalArgumentException("Event log must be set");
        }
        if (configuration.timeSource() == null) {
            throw new IllegalArgumentException("Time source must be set");
        }
        if (configuration.threadFactory() == null) {
            throw new IllegalArgumentException("Thread factory must be set");
        }
        return configuration;
    }
}

