/*
 * Decompiled with CFR 0.152.
 */
package org.tools4j.elara.factory;

import java.util.Arrays;
import java.util.Objects;
import java.util.function.Supplier;
import org.tools4j.elara.application.CommandProcessor;
import org.tools4j.elara.command.CompositeCommandProcessor;
import org.tools4j.elara.factory.ProcessorFactory;
import org.tools4j.elara.factory.Singletons;
import org.tools4j.elara.handler.CommandHandler;
import org.tools4j.elara.handler.CommandPollerHandler;
import org.tools4j.elara.handler.DefaultCommandHandler;
import org.tools4j.elara.init.Configuration;
import org.tools4j.elara.log.MessageLog;
import org.tools4j.elara.loop.CommandPollerStep;
import org.tools4j.elara.plugin.api.Plugin;
import org.tools4j.elara.plugin.base.BaseState;
import org.tools4j.elara.route.DefaultEventRouter;
import org.tools4j.nobark.loop.Step;

public class DefaultProcessorFactory
implements ProcessorFactory {
    private final Configuration configuration;
    private final Supplier<? extends Singletons> singletons;

    public DefaultProcessorFactory(Configuration configuration, Supplier<? extends Singletons> singletons) {
        this.configuration = Objects.requireNonNull(configuration);
        this.singletons = Objects.requireNonNull(singletons);
    }

    @Override
    public CommandProcessor commandProcessor() {
        CommandProcessor commandProcessor = this.configuration.commandProcessor();
        Plugin.Configuration[] plugins = this.singletons.get().plugins();
        if (plugins.length == 0) {
            return commandProcessor;
        }
        BaseState.Mutable baseState = this.singletons.get().baseState();
        CommandProcessor[] processors = new CommandProcessor[plugins.length + 1];
        int count = 1;
        for (Plugin.Configuration plugin : plugins) {
            processors[count] = plugin.commandProcessor(baseState);
            if (processors[count] == CommandProcessor.NOOP) continue;
            ++count;
        }
        if (count == 1) {
            return commandProcessor;
        }
        processors[0] = commandProcessor;
        return new CompositeCommandProcessor(count == processors.length ? processors : Arrays.copyOf(processors, count));
    }

    @Override
    public CommandHandler commandHandler() {
        return new DefaultCommandHandler(this.singletons.get().baseState(), new DefaultEventRouter(this.configuration.eventLog().appender(), this.singletons.get().eventHandler()), this.singletons.get().commandProcessor(), this.configuration.exceptionHandler(), this.configuration.duplicateHandler());
    }

    @Override
    public Step commandPollerStep() {
        MessageLog.Poller commandLogPoller;
        switch (this.configuration.commandLogMode()) {
            case REPLAY_ALL: {
                commandLogPoller = this.configuration.commandLog().poller();
                break;
            }
            case FROM_LAST: {
                commandLogPoller = this.configuration.commandLog().poller("elara-cmd");
                break;
            }
            case FROM_END: {
                commandLogPoller = this.configuration.commandLog().poller();
                commandLogPoller.moveToEnd();
                break;
            }
            default: {
                throw new IllegalArgumentException("Unsupported command log mode: " + (Object)((Object)this.configuration.commandLogMode()));
            }
        }
        return new CommandPollerStep(commandLogPoller, new CommandPollerHandler(this.singletons.get().commandHandler()));
    }
}

