/*
 * Decompiled with CFR 0.152.
 */
package org.tools4j.elara.plugin.timer;

import java.util.Objects;
import org.tools4j.elara.application.CommandProcessor;
import org.tools4j.elara.command.Command;
import org.tools4j.elara.plugin.timer.TimerCommands;
import org.tools4j.elara.plugin.timer.TimerEvents;
import org.tools4j.elara.plugin.timer.TimerState;
import org.tools4j.elara.route.EventRouter;

public class TimerCommandProcessor
implements CommandProcessor {
    private final TimerState timerState;

    public TimerCommandProcessor(TimerState timerState) {
        this.timerState = Objects.requireNonNull(timerState);
    }

    @Override
    public void onCommand(Command command, EventRouter router) {
        long timerId;
        if (command.type() == -10 && this.timerState.hasTimer(timerId = TimerCommands.timerId(command))) {
            int repetition = TimerCommands.timerRepetition(command);
            if (repetition == -1) {
                try (EventRouter.RoutingContext context = router.routingEvent(-11);){
                    int length = TimerEvents.timerExpired(context.buffer(), 0, command);
                    context.route(length);
                }
            }
            try (EventRouter.RoutingContext context = router.routingEvent(-10);){
                int length = TimerEvents.timerFired(context.buffer(), 0, command);
                context.route(length);
            }
        }
    }
}

