/*
 * Decompiled with CFR 0.152.
 */
package org.tools4j.elara.plugin.replication;

import org.agrona.DirectBuffer;
import org.agrona.MutableDirectBuffer;
import org.tools4j.elara.plugin.replication.ReplicationMessageDescriptor;

public enum ReplicationMessages {

    public static final short APPEND_REQUEST = -95;
    public static final short APPEND_RESPONSE = -96;
    public static final byte FLAG_APPEND_SUCCESS = 1;

    public static int appendRequest(MutableDirectBuffer buffer, int offset, int term, int leaderId, long logIndex, DirectBuffer payload, int payloadOffset, int payloadSize) {
        buffer.putByte(offset + 0, (byte)1);
        buffer.putByte(offset + 1, (byte)0);
        buffer.putShort(offset + 2, (short)-95);
        buffer.putInt(offset + 4, payloadSize);
        buffer.putInt(offset + 8, leaderId);
        buffer.putInt(offset + 12, term);
        buffer.putLong(offset + 16, logIndex);
        buffer.putLong(offset + 24, 0L);
        buffer.putBytes(offset + 32, payload, payloadOffset, payloadSize);
        return 32 + payloadSize;
    }

    public static int appendResponse(MutableDirectBuffer buffer, int offset, int term, int leaderId, long nextEventLogIndex, boolean success) {
        buffer.putByte(offset + 0, (byte)1);
        buffer.putByte(offset + 1, success ? (byte)1 : 0);
        buffer.putShort(offset + 2, (short)-96);
        buffer.putInt(offset + 4, 0);
        buffer.putInt(offset + 8, leaderId);
        buffer.putInt(offset + 12, term);
        buffer.putLong(offset + 16, nextEventLogIndex);
        buffer.putLong(offset + 24, 0L);
        return 32;
    }

    public static byte version(DirectBuffer buffer) {
        return ReplicationMessageDescriptor.version(buffer);
    }

    public static byte flags(DirectBuffer buffer) {
        return ReplicationMessageDescriptor.flags(buffer);
    }

    public static boolean isAppendSuccess(DirectBuffer buffer) {
        return (1 & ReplicationMessages.flags(buffer)) != 0;
    }

    public static byte type(DirectBuffer buffer) {
        return ReplicationMessageDescriptor.type(buffer);
    }

    public static int candidateId(DirectBuffer buffer) {
        return ReplicationMessageDescriptor.candidateId(buffer);
    }

    public static int leaderId(DirectBuffer buffer) {
        return ReplicationMessageDescriptor.leaderId(buffer);
    }

    public static int term(DirectBuffer buffer) {
        return ReplicationMessageDescriptor.term(buffer);
    }

    public static int logIndex(DirectBuffer buffer) {
        return ReplicationMessageDescriptor.logIndex(buffer);
    }

    public static int committedLogIndex(DirectBuffer buffer) {
        return ReplicationMessageDescriptor.committedLogIndex(buffer);
    }

    public static int payloadSize(DirectBuffer buffer) {
        return ReplicationMessageDescriptor.payloadSize(buffer);
    }

    public static boolean isReplicationMessageType(int type) {
        switch (type) {
            case -96: 
            case -95: {
                return true;
            }
        }
        return false;
    }

    public static String replicationMessageName(int type) {
        switch (type) {
            case -95: {
                return "APPEND_REQUEST";
            }
            case -96: {
                return "APPEND_RESPONSE";
            }
        }
        throw new IllegalArgumentException("Not a replication message type: " + type);
    }
}

