/*
 * Decompiled with CFR 0.152.
 */
package org.tools4j.elara.plugin.replication;

import org.agrona.MutableDirectBuffer;
import org.tools4j.elara.event.Event;
import org.tools4j.elara.flyweight.Frame;
import org.tools4j.elara.plugin.replication.ReplicationPayloadDescriptor;

public enum ReplicationEvents {

    public static final short LEADER_ELECTED = -90;
    public static final short LEADER_ENFORCED = -99;

    public static int leaderElected(MutableDirectBuffer buffer, int offset, int term, int leaderId) {
        buffer.putByte(offset + 0, (byte)1);
        buffer.putByte(offset + 1, (byte)0);
        buffer.putShort(offset + 2, (short)-90);
        buffer.putInt(offset + 4, 0);
        buffer.putInt(offset + 8, leaderId);
        buffer.putInt(offset + 12, term);
        return 16;
    }

    public static int leaderEnforced(MutableDirectBuffer buffer, int offset, int term, int leaderId) {
        buffer.putByte(offset + 1, (byte)0);
        buffer.putShort(offset + 2, (short)-99);
        buffer.putInt(offset + 4, 0);
        buffer.putInt(offset + 8, leaderId);
        buffer.putInt(offset + 12, term);
        return 16;
    }

    public static int term(Event event) {
        return ReplicationPayloadDescriptor.term(event.payload());
    }

    public static int leaderId(Event event) {
        return ReplicationPayloadDescriptor.leaderId(event.payload());
    }

    public static boolean isReplicationEvent(Event event) {
        return ReplicationEvents.isReplicationEventType(event.type());
    }

    public static boolean isReplicationEvent(Frame frame) {
        return frame.header().index() >= 0 && ReplicationEvents.isReplicationEventType(frame.header().type());
    }

    public static boolean isReplicationEventType(int eventType) {
        switch (eventType) {
            case -99: 
            case -90: {
                return true;
            }
        }
        return false;
    }

    public static String replicationEventName(Event event) {
        return ReplicationEvents.replicationEventName(event.type());
    }

    public static String replicationEventName(Frame frame) {
        return ReplicationEvents.replicationEventName(frame.header().type());
    }

    public static String replicationEventName(int eventType) {
        switch (eventType) {
            case -90: {
                return "LEADER_ELECTED";
            }
            case -99: {
                return "LEADER_ENFORCED";
            }
        }
        throw new IllegalArgumentException("Not a replication event type: " + eventType);
    }
}

