/*
 * Decompiled with CFR 0.152.
 */
package org.tools4j.elara.plugin.replication;

import java.util.Objects;
import org.tools4j.elara.application.EventApplier;
import org.tools4j.elara.event.Event;
import org.tools4j.elara.logging.ElaraLogger;
import org.tools4j.elara.logging.Logger;
import org.tools4j.elara.plugin.base.BaseState;
import org.tools4j.elara.plugin.replication.Configuration;
import org.tools4j.elara.plugin.replication.ReplicationEvents;
import org.tools4j.elara.plugin.replication.ReplicationState;

public class ReplicationEventApplier
implements EventApplier {
    private final ElaraLogger logger;
    private final Configuration configuration;
    private final BaseState.Mutable baseState;
    private final ReplicationState.Mutable replicationState;

    public ReplicationEventApplier(Logger.Factory loggerFactory, Configuration configuration, BaseState.Mutable baseState, ReplicationState.Mutable replicationState) {
        this.logger = ElaraLogger.create(loggerFactory, this.getClass());
        this.configuration = Objects.requireNonNull(configuration);
        this.baseState = Objects.requireNonNull(baseState);
        this.replicationState = Objects.requireNonNull(replicationState);
    }

    @Override
    public void onEvent(Event event) {
        switch (event.type()) {
            case -99: 
            case -90: {
                this.updateLeader(event);
            }
        }
        this.replicationState.eventApplied(event);
    }

    private void updateLeader(Event event) {
        int leaderId = ReplicationEvents.leaderId(event);
        int term = ReplicationEvents.term(event);
        this.updateLeader(ReplicationEvents.replicationEventName(event), term, leaderId);
    }

    private void updateLeader(String eventName, int term, int leaderId) {
        int serverId = this.configuration.serverId();
        this.baseState.processCommands(leaderId == serverId);
        this.replicationState.leaderId(leaderId).currentTerm(term);
        this.logger.info("Server {} applied {}: Updating leader to {} for term {}").replace(serverId).replace(eventName).replace(leaderId).replace(term).format();
    }
}

