/*
 * Decompiled with CFR 0.152.
 */
package org.tools4j.elara.plugin.replication;

import org.agrona.MutableDirectBuffer;
import org.tools4j.elara.command.Command;
import org.tools4j.elara.flyweight.Frame;
import org.tools4j.elara.plugin.replication.ReplicationPayloadDescriptor;

public enum ReplicationCommands {

    public static final short PROPOSE_LEADER = -90;

    public static int proposeLeader(MutableDirectBuffer buffer, int offset, int candidateId) {
        buffer.putByte(offset + 0, (byte)1);
        buffer.putByte(offset + 1, (byte)0);
        buffer.putShort(offset + 2, (short)-90);
        buffer.putInt(offset + 4, 0);
        buffer.putInt(offset + 8, candidateId);
        buffer.putInt(offset + 12, 0);
        return 16;
    }

    public static int candidateId(Command command) {
        return ReplicationPayloadDescriptor.candidateId(command.payload());
    }

    public static boolean isReplicationCommand(Command command) {
        return ReplicationCommands.isReplicationCommandType(command.type());
    }

    public static boolean isReplicationCommand(Frame frame) {
        return frame.header().index() >= 0 && ReplicationCommands.isReplicationCommandType(frame.header().type());
    }

    public static boolean isReplicationCommandType(int commandType) {
        switch (commandType) {
            case -90: {
                return true;
            }
        }
        return false;
    }

    public static String replicationCommandName(Command command) {
        return ReplicationCommands.replicationCommandName(command.type());
    }

    public static String replicationCommandName(Frame frame) {
        return ReplicationCommands.replicationCommandName(frame.header().type());
    }

    public static String replicationCommandName(int commandType) {
        switch (commandType) {
            case -90: {
                return "PROPOSE_LEADER";
            }
        }
        throw new IllegalArgumentException("Not a replication command type: " + commandType);
    }
}

