/*
 * Decompiled with CFR 0.152.
 */
package org.tools4j.elara.plugin.replication;

import org.agrona.DirectBuffer;
import org.agrona.collections.Int2ObjectHashMap;
import org.tools4j.elara.plugin.replication.Configuration;
import org.tools4j.elara.plugin.replication.Connection;

public class DispatchingPublisher
implements Connection.Publisher {
    private final Int2ObjectHashMap<Connection.Publisher> publisherByServerId = new Int2ObjectHashMap();

    public DispatchingPublisher(Configuration configuration) {
        int currentServerId = configuration.serverId();
        for (int serverId : configuration.serverIds()) {
            if (serverId == currentServerId) continue;
            Connection.Publisher publisher = configuration.connection(serverId).publisher();
            this.publisherByServerId.put(serverId, (Object)publisher);
        }
    }

    @Override
    public boolean publish(int targetServerId, DirectBuffer buffer, int offset, int length) {
        Connection.Publisher publisher = (Connection.Publisher)this.publisherByServerId.get(targetServerId);
        if (publisher != null) {
            return publisher.publish(targetServerId, buffer, offset, length);
        }
        return false;
    }
}

