/*
 * Decompiled with CFR 0.152.
 */
package org.tools4j.elara.plugin.metrics;

import java.util.Objects;
import org.tools4j.elara.factory.InterceptableSingletons;
import org.tools4j.elara.factory.Singletons;
import org.tools4j.elara.init.ExecutionType;
import org.tools4j.elara.plugin.api.Plugin;
import org.tools4j.elara.plugin.base.BaseState;
import org.tools4j.elara.plugin.metrics.Configuration;
import org.tools4j.elara.plugin.metrics.DefaultMetricsState;
import org.tools4j.elara.plugin.metrics.FrequencyMetricsLoggerStep;
import org.tools4j.elara.plugin.metrics.MetricsCapturingInterceptor;
import org.tools4j.elara.plugin.metrics.MetricsState;
import org.tools4j.nobark.loop.Step;

public class MetricsPlugin
implements Plugin<MetricsState> {
    private final Configuration configuration;

    public MetricsPlugin(Configuration configuration) {
        this.configuration = Configuration.validate(configuration);
    }

    @Override
    public MetricsState defaultPluginState() {
        return new DefaultMetricsState();
    }

    @Override
    public Plugin.Configuration configuration(final org.tools4j.elara.init.Configuration appConfig, final MetricsState pluginState) {
        Objects.requireNonNull(appConfig);
        Objects.requireNonNull(pluginState);
        return new Plugin.Configuration.Default(){

            @Override
            public Step step(BaseState baseState, ExecutionType executionType) {
                if (MetricsPlugin.this.configuration.frequencyMetrics().isEmpty() || executionType != ExecutionType.ALWAYS) {
                    return Step.NO_OP;
                }
                return new FrequencyMetricsLoggerStep(appConfig.timeSource(), MetricsPlugin.this.configuration, pluginState);
            }

            @Override
            public InterceptableSingletons interceptOrNull(Singletons singletons) {
                return new MetricsCapturingInterceptor(singletons, appConfig.timeSource(), MetricsPlugin.this.configuration, pluginState);
            }
        };
    }
}

