/*
 * Decompiled with CFR 0.152.
 */
package org.tools4j.elara.plugin.metrics;

import java.util.Objects;
import org.agrona.DirectBuffer;
import org.agrona.MutableDirectBuffer;
import org.agrona.concurrent.UnsafeBuffer;
import org.tools4j.elara.application.CommandProcessor;
import org.tools4j.elara.application.EventApplier;
import org.tools4j.elara.factory.InterceptableSingletons;
import org.tools4j.elara.factory.Singletons;
import org.tools4j.elara.handler.CommandHandler;
import org.tools4j.elara.handler.EventHandler;
import org.tools4j.elara.handler.OutputHandler;
import org.tools4j.elara.input.Receiver;
import org.tools4j.elara.log.MessageLog;
import org.tools4j.elara.output.Output;
import org.tools4j.elara.plugin.metrics.Configuration;
import org.tools4j.elara.plugin.metrics.FrequencyMetric;
import org.tools4j.elara.plugin.metrics.MetricsState;
import org.tools4j.elara.plugin.metrics.TimeMetric;
import org.tools4j.elara.plugin.metrics.TimeMetricsLogger;
import org.tools4j.elara.route.EventRouter;
import org.tools4j.elara.time.TimeSource;
import org.tools4j.nobark.loop.Step;

public class MetricsCapturingInterceptor
extends InterceptableSingletons {
    private final TimeSource timeSource;
    private final Configuration configuration;
    private final MetricsState state;
    private final TimeMetricsLogger logger;

    public MetricsCapturingInterceptor(Singletons delegate, TimeSource timeSource, Configuration configuration, MetricsState state) {
        super(delegate);
        this.timeSource = Objects.requireNonNull(timeSource);
        this.configuration = Objects.requireNonNull(configuration);
        this.state = Objects.requireNonNull(state);
        this.logger = new TimeMetricsLogger(timeSource, configuration, state);
    }

    private boolean shouldCapture(TimeMetric metric) {
        return this.configuration.timeMetrics().contains((Object)metric);
    }

    private boolean shouldCapture(FrequencyMetric metric) {
        return this.configuration.frequencyMetrics().contains((Object)metric);
    }

    private boolean shouldCaptureAnyOf(TimeMetric.Target target) {
        return target.anyOf(this.configuration.timeMetrics());
    }

    private void captureInputSendingTime(int source, long sequence, int type, DirectBuffer buffer, int offset, int length) {
        if (this.shouldCapture(TimeMetric.INPUT_SENDING_TIME)) {
            long sendingTime = this.configuration.inputSendingTimeExtractor().sendingTime(source, sequence, type, buffer, offset, length);
            this.state.time(TimeMetric.INPUT_SENDING_TIME, sendingTime);
        }
    }

    private void captureTime(TimeMetric metric) {
        if (this.shouldCapture(metric)) {
            this.state.time(metric, this.timeSource.currentTime());
        }
    }

    private void captureCount(FrequencyMetric metric) {
        if (this.shouldCapture(metric)) {
            this.state.counter(metric, 1L);
        }
    }

    private Step counterStep(FrequencyMetric invokedMetric, FrequencyMetric performedMetric, Step step) {
        Objects.requireNonNull(step);
        if (this.shouldCapture(FrequencyMetric.STEP_ERROR_FREQUENCY)) {
            if (this.shouldCapture(invokedMetric) || this.shouldCapture(performedMetric)) {
                return () -> {
                    try {
                        boolean result = step.perform();
                        this.captureCount(invokedMetric);
                        if (result) {
                            this.captureCount(performedMetric);
                        }
                        return result;
                    }
                    catch (Throwable t) {
                        this.captureCount(FrequencyMetric.STEP_ERROR_FREQUENCY);
                        throw t;
                    }
                };
            }
            return () -> {
                try {
                    return step.perform();
                }
                catch (Throwable t) {
                    this.captureCount(FrequencyMetric.STEP_ERROR_FREQUENCY);
                    throw t;
                }
            };
        }
        if (this.shouldCapture(invokedMetric) || this.shouldCapture(performedMetric)) {
            return () -> {
                boolean result = step.perform();
                this.captureCount(invokedMetric);
                if (result) {
                    this.captureCount(performedMetric);
                }
                return result;
            };
        }
        return step;
    }

    @Override
    public Step dutyCycleStep() {
        return this.counterStep(FrequencyMetric.DUTY_CYCLE_FREQUENCY, FrequencyMetric.DUTY_CYCLE_PERFORMED_FREQUENCY, this.singletons().dutyCycleStep());
    }

    @Override
    public Step sequencerStep() {
        return this.counterStep(FrequencyMetric.INPUTS_POLL_FREQUENCY, FrequencyMetric.INPUT_RECEIVED_FREQUENCY, this.singletons().sequencerStep());
    }

    @Override
    public Step commandPollerStep() {
        return this.counterStep(FrequencyMetric.COMMAND_POLL_FREQUENCY, FrequencyMetric.COMMAND_PROCESSED_FREQUENCY, this.singletons().commandPollerStep());
    }

    @Override
    public Step eventPollerStep() {
        return this.counterStep(FrequencyMetric.EVENT_POLL_FREQUENCY, FrequencyMetric.EVENT_APPLIED_FREQUENCY, this.singletons().eventPollerStep());
    }

    @Override
    public Step outputStep() {
        return this.counterStep(FrequencyMetric.OUTPUT_POLL_FREQUENCY, FrequencyMetric.OUTPUT_PUBLISHED_FREQUENCY, this.singletons().outputStep());
    }

    @Override
    public Step dutyCycleExtraStep() {
        return this.counterStep(FrequencyMetric.EXTRA_STEP_INVOCATION_FREQUENCY, FrequencyMetric.EXTRA_STEP_PERFORMED_FREQUENCY, this.singletons().dutyCycleExtraStep());
    }

    @Override
    public Receiver receiver() {
        Receiver receiver = Objects.requireNonNull(this.singletons().receiver());
        if (this.shouldCapture(TimeMetric.INPUT_SENDING_TIME) || this.shouldCapture(TimeMetric.INPUT_POLLING_TIME) || this.shouldCapture(TimeMetric.COMMAND_APPENDING_TIME)) {
            return this.timedReceiver(receiver);
        }
        return receiver;
    }

    @Override
    public CommandHandler commandHandler() {
        CommandHandler commandHandler = Objects.requireNonNull(this.singletons().commandHandler());
        if (this.shouldCaptureAnyOf(TimeMetric.Target.COMMAND)) {
            return command -> {
                this.captureTime(TimeMetric.COMMAND_POLLING_TIME);
                MessageLog.Handler.Result result = commandHandler.onCommand(command);
                this.captureTime(TimeMetric.PROCESSING_END_TIME);
                this.logger.logMetrics(command);
                return result;
            };
        }
        return commandHandler;
    }

    @Override
    public CommandProcessor commandProcessor() {
        CommandProcessor commandProcessor = Objects.requireNonNull(this.singletons().commandProcessor());
        if (this.shouldCapture(TimeMetric.PROCESSING_START_TIME) || this.shouldCapture(TimeMetric.ROUTING_START_TIME) || this.shouldCapture(TimeMetric.ROUTING_END_TIME)) {
            return (command, router) -> {
                EventRouter eventRouter = this.shouldCapture(TimeMetric.ROUTING_START_TIME) || this.shouldCapture(TimeMetric.ROUTING_END_TIME) ? this.timedEventRouter(router) : router;
                this.captureTime(TimeMetric.PROCESSING_START_TIME);
                commandProcessor.onCommand(command, eventRouter);
            };
        }
        return commandProcessor;
    }

    @Override
    public EventApplier eventApplier() {
        EventApplier eventApplier = Objects.requireNonNull(this.singletons().eventApplier());
        if (this.shouldCaptureAnyOf(TimeMetric.Target.EVENT)) {
            return event -> {
                this.captureTime(TimeMetric.APPLYING_START_TIME);
                eventApplier.onEvent(event);
                this.captureTime(TimeMetric.APPLYING_END_TIME);
                this.logger.logMetrics(TimeMetric.Target.EVENT, event);
            };
        }
        return eventApplier;
    }

    @Override
    public EventHandler eventHandler() {
        EventHandler eventHandler = Objects.requireNonNull(this.singletons().eventHandler());
        if (this.shouldCapture(TimeMetric.EVENT_POLLING_TIME)) {
            return event -> {
                this.captureTime(TimeMetric.EVENT_POLLING_TIME);
                eventHandler.onEvent(event);
            };
        }
        return eventHandler;
    }

    @Override
    public OutputHandler outputHandler() {
        OutputHandler outputHandler = Objects.requireNonNull(this.singletons().outputHandler());
        if (this.shouldCapture(TimeMetric.OUTPUT_POLLING_TIME)) {
            return (event, replay, retry) -> {
                this.captureTime(TimeMetric.OUTPUT_POLLING_TIME);
                return outputHandler.publish(event, replay, retry);
            };
        }
        return outputHandler;
    }

    @Override
    public Output output() {
        Output output = Objects.requireNonNull(this.singletons().output());
        if (this.shouldCaptureAnyOf(TimeMetric.Target.OUTPUT)) {
            return (event, replay, retry, loopback) -> {
                this.captureTime(TimeMetric.OUTPUT_START_TIME);
                Output.Ack ack = output.publish(event, replay, retry, loopback);
                this.captureTime(TimeMetric.OUTPUT_END_TIME);
                this.logger.logMetrics(TimeMetric.Target.OUTPUT, event);
                return ack;
            };
        }
        return output;
    }

    private EventRouter timedEventRouter(final EventRouter eventRouter) {
        Objects.requireNonNull(eventRouter);
        return new EventRouter.Default(){
            final EventRouter router;
            final TimedRoutingContext context;
            {
                this.router = eventRouter;
                this.context = new TimedRoutingContext();
            }

            @Override
            public EventRouter.RoutingContext routingEvent(int type) {
                MetricsCapturingInterceptor.this.captureTime(TimeMetric.ROUTING_START_TIME);
                return this.context.init(this.router.routingEvent(type));
            }

            @Override
            public short nextEventIndex() {
                return this.router.nextEventIndex();
            }

            @Override
            public boolean skipCommand() {
                return this.router.skipCommand();
            }

            @Override
            public boolean isSkipped() {
                return this.router.isSkipped();
            }
        };
    }

    private Receiver timedReceiver(final Receiver receiver) {
        Objects.requireNonNull(receiver);
        return new Receiver(){
            final DirectBuffer empty = new UnsafeBuffer(0L, 0);
            final TimedReceivingContext context = MetricsCapturingInterceptor.access$200(MetricsCapturingInterceptor.this, TimeMetric.INPUT_SENDING_TIME) || MetricsCapturingInterceptor.access$200(MetricsCapturingInterceptor.this, TimeMetric.COMMAND_APPENDING_TIME) ? new TimedReceivingContext() : null;

            Receiver.ReceivingContext receivingContext(int source, long sequence, int type, Receiver.ReceivingContext receivingContext) {
                return this.context != null ? this.context.init(source, sequence, type, receivingContext) : receivingContext;
            }

            @Override
            public Receiver.ReceivingContext receivingMessage(int source, long sequence) {
                MetricsCapturingInterceptor.this.captureTime(TimeMetric.INPUT_POLLING_TIME);
                return this.receivingContext(source, sequence, 0, receiver.receivingMessage(source, sequence));
            }

            @Override
            public Receiver.ReceivingContext receivingMessage(int source, long sequence, int type) {
                MetricsCapturingInterceptor.this.captureTime(TimeMetric.INPUT_POLLING_TIME);
                return this.receivingContext(source, sequence, type, receiver.receivingMessage(source, sequence, type));
            }

            @Override
            public void receiveMessage(int source, long sequence, DirectBuffer buffer, int offset, int length) {
                MetricsCapturingInterceptor.this.captureTime(TimeMetric.INPUT_POLLING_TIME);
                MetricsCapturingInterceptor.this.captureInputSendingTime(source, sequence, 0, buffer, offset, length);
                receiver.receiveMessage(source, sequence, buffer, offset, length);
                MetricsCapturingInterceptor.this.captureTime(TimeMetric.COMMAND_APPENDING_TIME);
            }

            @Override
            public void receiveMessage(int source, long sequence, int type, DirectBuffer buffer, int offset, int length) {
                MetricsCapturingInterceptor.this.captureTime(TimeMetric.INPUT_POLLING_TIME);
                MetricsCapturingInterceptor.this.captureInputSendingTime(source, sequence, type, buffer, offset, length);
                receiver.receiveMessage(source, sequence, type, buffer, offset, length);
                MetricsCapturingInterceptor.this.captureTime(TimeMetric.COMMAND_APPENDING_TIME);
            }

            @Override
            public void receiveMessageWithoutPayload(int source, long sequence, int type) {
                MetricsCapturingInterceptor.this.captureTime(TimeMetric.INPUT_POLLING_TIME);
                MetricsCapturingInterceptor.this.captureInputSendingTime(source, sequence, type, this.unwrap(this.empty), 0, 0);
                this.unwrap(this.empty);
                receiver.receiveMessageWithoutPayload(source, sequence, type);
                MetricsCapturingInterceptor.this.captureTime(TimeMetric.COMMAND_APPENDING_TIME);
            }

            DirectBuffer unwrap(DirectBuffer buffer) {
                this.empty.wrap(0L, 0);
                return this.empty;
            }
        };
    }

    private final class TimedReceivingContext
    implements Receiver.ReceivingContext {
        int source;
        long sequence;
        int type;
        Receiver.ReceivingContext context;

        private TimedReceivingContext() {
        }

        TimedReceivingContext init(int source, long sequence, int type, Receiver.ReceivingContext context) {
            this.source = source;
            this.sequence = sequence;
            this.type = type;
            this.context = Objects.requireNonNull(context);
            return this;
        }

        Receiver.ReceivingContext unclosedContext() {
            if (this.context != null) {
                return this.context;
            }
            throw new IllegalStateException("Receiving context is closed");
        }

        @Override
        public MutableDirectBuffer buffer() {
            return this.unclosedContext().buffer();
        }

        @Override
        public void receive(int length) {
            Receiver.ReceivingContext rc = this.captureInputSendingTime(length);
            rc.receive(length);
            this.context = null;
            MetricsCapturingInterceptor.this.captureTime(TimeMetric.COMMAND_APPENDING_TIME);
        }

        @Override
        public void abort() {
            if (this.context != null) {
                this.context.abort();
                this.context = null;
            }
        }

        @Override
        public boolean isClosed() {
            return this.context == null || this.context.isClosed();
        }

        Receiver.ReceivingContext captureInputSendingTime(int length) {
            if (!MetricsCapturingInterceptor.this.shouldCapture(TimeMetric.INPUT_SENDING_TIME)) {
                return this.unclosedContext();
            }
            if (length < 0) {
                throw new IllegalArgumentException("Length cannot be negative: " + length);
            }
            Receiver.ReceivingContext rc = this.unclosedContext();
            MetricsCapturingInterceptor.this.captureInputSendingTime(this.source, this.sequence, this.type, (DirectBuffer)rc.buffer(), 0, length);
            return rc;
        }
    }

    private final class TimedRoutingContext
    implements EventRouter.RoutingContext {
        EventRouter.RoutingContext context;

        private TimedRoutingContext() {
        }

        TimedRoutingContext init(EventRouter.RoutingContext context) {
            this.context = Objects.requireNonNull(context);
            return this;
        }

        EventRouter.RoutingContext unclosedContext() {
            if (this.context != null) {
                return this.context;
            }
            throw new IllegalStateException("Routing context is closed");
        }

        @Override
        public int index() {
            return this.unclosedContext().index();
        }

        @Override
        public MutableDirectBuffer buffer() {
            return this.unclosedContext().buffer();
        }

        @Override
        public void route(int length) {
            MetricsCapturingInterceptor.this.captureTime(TimeMetric.ROUTING_END_TIME);
            this.unclosedContext().route(length);
            this.context = null;
        }

        @Override
        public void abort() {
            if (this.context != null) {
                this.context.abort();
                this.context = null;
            }
        }

        @Override
        public boolean isClosed() {
            return this.context == null || this.context.isClosed();
        }
    }
}

