/*
 * Decompiled with CFR 0.152.
 */
package org.tools4j.elara.plugin.metrics;

import java.util.Objects;
import org.agrona.MutableDirectBuffer;
import org.tools4j.elara.log.MessageLog;
import org.tools4j.elara.plugin.metrics.Configuration;
import org.tools4j.elara.plugin.metrics.FlyweightMetricsLogEntry;
import org.tools4j.elara.plugin.metrics.FrequencyMetric;
import org.tools4j.elara.plugin.metrics.MetricsState;
import org.tools4j.elara.time.TimeSource;
import org.tools4j.nobark.loop.Step;

public class FrequencyMetricsLoggerStep
implements Step {
    private final TimeSource timeSource;
    private final Configuration configuration;
    private final MetricsState state;
    private final long logInterval;
    private final MessageLog.Appender appender;
    private long repetition;
    private long lastLogTime;

    public FrequencyMetricsLoggerStep(TimeSource timeSource, Configuration configuration, MetricsState state) {
        this.timeSource = Objects.requireNonNull(timeSource);
        this.configuration = Objects.requireNonNull(configuration);
        this.state = Objects.requireNonNull(state);
        if (configuration.frequencyMetrics().isEmpty()) {
            throw new IllegalArgumentException("Configuration contains no frequency metrics");
        }
        this.logInterval = configuration.frequencyLogInterval();
        if (this.logInterval <= 0L) {
            throw new IllegalArgumentException("Frequency log interval must be positive: " + this.logInterval);
        }
        this.appender = Objects.requireNonNull(configuration.frequencyMetricsLog(), "configuration.frequencyMetricsLog()").appender();
    }

    public boolean perform() {
        long time;
        boolean performed = false;
        if (this.repetition == 0L) {
            this.state.clearFrequencyMetrics();
            performed = true;
        }
        if ((time = this.timeSource.currentTime()) - this.lastLogTime >= this.logInterval || this.repetition == 0L) {
            this.logMetrics(time);
            this.state.clearFrequencyMetrics();
            this.lastLogTime = time;
            ++this.repetition;
            performed = true;
        }
        return performed;
    }

    private void logMetrics(long time) {
        short choice = FrequencyMetric.choice(this.configuration.frequencyMetrics());
        int count = FrequencyMetric.count(choice);
        try (MessageLog.AppendingContext context = this.appender.appending();){
            int headerLen;
            MutableDirectBuffer buffer = context.buffer();
            int offset = headerLen = FlyweightMetricsLogEntry.writeFrequencyMetricsHeader(choice, (int)this.repetition, this.logInterval, time, buffer, 0);
            for (int i = 0; i < count; ++i) {
                FrequencyMetric metric = FrequencyMetric.metric(choice, i);
                long counter = this.state.counter(metric);
                offset += FlyweightMetricsLogEntry.writeCounter(counter, buffer, offset);
            }
            int length = offset;
            context.commit(length);
        }
    }
}

