/*
 * Decompiled with CFR 0.152.
 */
package org.tools4j.elara.plugin.metrics;

import java.util.Arrays;
import org.tools4j.elara.plugin.metrics.FrequencyMetric;
import org.tools4j.elara.plugin.metrics.MetricsState;
import org.tools4j.elara.plugin.metrics.TimeMetric;

public class DefaultMetricsState
implements MetricsState {
    private final long[] times = new long[TimeMetric.count()];
    private final long[] counters = new long[FrequencyMetric.count()];

    @Override
    public long time(TimeMetric metric) {
        return this.times[metric.ordinal()];
    }

    @Override
    public long counter(FrequencyMetric metric) {
        return this.counters[metric.ordinal()];
    }

    @Override
    public MetricsState time(TimeMetric metric, long time) {
        this.times[metric.ordinal()] = time;
        return this;
    }

    @Override
    public MetricsState counter(FrequencyMetric metric, long add) {
        int n = metric.ordinal();
        this.counters[n] = this.counters[n] + add;
        return this;
    }

    @Override
    public MetricsState clear(TimeMetric metric) {
        this.times[metric.ordinal()] = 0L;
        return this;
    }

    @Override
    public MetricsState clear(FrequencyMetric metric) {
        this.counters[metric.ordinal()] = 0L;
        return this;
    }

    @Override
    public MetricsState clearTimeMetrics() {
        Arrays.fill(this.times, 0L);
        return this;
    }

    @Override
    public MetricsState clearFrequencyMetrics() {
        Arrays.fill(this.counters, 0L);
        return this;
    }

    @Override
    public MetricsState clear() {
        this.clearTimeMetrics();
        this.clearFrequencyMetrics();
        return this;
    }
}

