/*
 * Decompiled with CFR 0.152.
 */
package org.tools4j.elara.plugin.boot;

import org.tools4j.elara.command.Command;
import org.tools4j.elara.flyweight.Frame;

public enum BootCommands {

    public static final int SIGNAL_APP_INITIALISATION_START = -20;
    public static final int SIGNAL_APP_INITIALISATION_COMPLETE = -21;

    public static boolean isBootCommand(Command command) {
        return BootCommands.isBootCommandType(command.type());
    }

    public static boolean isBootCommand(Frame frame) {
        return frame.header().index() >= 0 && BootCommands.isBootCommandType(frame.header().type());
    }

    public static boolean isBootCommandType(int commandType) {
        switch (commandType) {
            case -21: 
            case -20: {
                return true;
            }
        }
        return false;
    }

    public static String bootCommandName(Command command) {
        return BootCommands.bootCommandName(command.type());
    }

    public static String bootCommandName(Frame frame) {
        return BootCommands.bootCommandName(frame.header().type());
    }

    public static String bootCommandName(int commandType) {
        switch (commandType) {
            case -20: {
                return "SIGNAL_APP_INITIALISATION_START";
            }
            case -21: {
                return "SIGNAL_APP_INITIALISATION_COMPLETE";
            }
        }
        throw new IllegalArgumentException("Not a boot command type: " + commandType);
    }
}

