/*
 * Decompiled with CFR 0.152.
 */
package org.tools4j.elara.plugin.api;

import java.util.Objects;
import java.util.function.Consumer;
import org.tools4j.elara.application.CommandProcessor;
import org.tools4j.elara.application.EventApplier;
import org.tools4j.elara.factory.InterceptableSingletons;
import org.tools4j.elara.factory.Singletons;
import org.tools4j.elara.init.ExecutionType;
import org.tools4j.elara.input.Input;
import org.tools4j.elara.output.Output;
import org.tools4j.elara.plugin.base.BaseState;
import org.tools4j.nobark.loop.Step;

public interface Plugin<P> {
    public static final Input[] NO_INPUTS = new Input[0];
    public static final Dependency<?>[] NO_DEPENDENCIES = new Dependency[0];
    public static final Consumer<Object> STATE_UNAWARE = state -> {};

    public P defaultPluginState();

    public Configuration configuration(org.tools4j.elara.init.Configuration var1, P var2);

    default public Dependency<?>[] dependencies() {
        return NO_DEPENDENCIES;
    }

    public static enum NullState {
        NULL;

    }

    @FunctionalInterface
    public static interface Dependency<P> {
        public Plugin<P> plugin();

        default public Consumer<? super P> pluginStateAware() {
            return STATE_UNAWARE;
        }

        public static <P> Dependency<P> of(Plugin<P> plugin) {
            Objects.requireNonNull(plugin);
            return () -> plugin;
        }

        public static <P> Dependency<P> of(final Plugin<P> plugin, final Consumer<? super P> pluginStateAware) {
            Objects.requireNonNull(plugin);
            Objects.requireNonNull(pluginStateAware);
            return new Dependency<P>(){

                @Override
                public Plugin<P> plugin() {
                    return plugin;
                }

                @Override
                public Consumer<? super P> pluginStateAware() {
                    return pluginStateAware;
                }
            };
        }
    }

    public static interface Configuration {
        public Step step(BaseState var1, ExecutionType var2);

        public Input[] inputs(BaseState var1);

        public Output output(BaseState var1);

        public CommandProcessor commandProcessor(BaseState var1);

        public EventApplier eventApplier(BaseState.Mutable var1);

        public InterceptableSingletons interceptOrNull(Singletons var1);

        public static interface Default
        extends Configuration {
            @Override
            default public Step step(BaseState baseState, ExecutionType executionType) {
                return Step.NO_OP;
            }

            @Override
            default public Input[] inputs(BaseState baseState) {
                return NO_INPUTS;
            }

            @Override
            default public Output output(BaseState baseState) {
                return Output.NOOP;
            }

            @Override
            default public CommandProcessor commandProcessor(BaseState baseState) {
                return CommandProcessor.NOOP;
            }

            @Override
            default public EventApplier eventApplier(BaseState.Mutable baseState) {
                return EventApplier.NOOP;
            }

            @Override
            default public InterceptableSingletons interceptOrNull(Singletons singletons) {
                return null;
            }
        }
    }
}

