/*
 * Decompiled with CFR 0.152.
 */
package org.tools4j.elara.output;

import org.agrona.DirectBuffer;
import org.agrona.MutableDirectBuffer;

public interface CommandLoopback {
    public EnqueuingContext enqueuingCommand();

    public EnqueuingContext enqueuingCommand(int var1);

    public void enqueueCommand(DirectBuffer var1, int var2, int var3);

    public void enqueueCommand(int var1, DirectBuffer var2, int var3, int var4);

    public void enqueueCommandWithoutPayload(int var1);

    public static interface Default
    extends CommandLoopback {
        @Override
        default public EnqueuingContext enqueuingCommand() {
            return this.enqueuingCommand(0);
        }

        @Override
        default public void enqueueCommand(DirectBuffer command, int offset, int length) {
            this.enqueueCommand(0, command, offset, length);
        }

        @Override
        default public void enqueueCommand(int type, DirectBuffer command, int offset, int length) {
            try (EnqueuingContext context = this.enqueuingCommand(type);){
                context.buffer().putBytes(0, command, offset, length);
                context.enqueue(length);
            }
        }

        @Override
        default public void enqueueCommandWithoutPayload(int type) {
            try (EnqueuingContext context = this.enqueuingCommand(type);){
                context.enqueue(0);
            }
        }
    }

    public static interface EnqueuingContext
    extends AutoCloseable {
        public MutableDirectBuffer buffer();

        public void enqueue(int var1);

        public void abort();

        public boolean isClosed();

        @Override
        default public void close() {
            if (!this.isClosed()) {
                this.abort();
            }
        }
    }
}

