/*
 * Decompiled with CFR 0.152.
 */
package org.tools4j.elara.loop;

import java.util.Objects;
import java.util.concurrent.ThreadFactory;
import org.tools4j.elara.factory.RunnerFactory;
import org.tools4j.nobark.loop.ExceptionHandler;
import org.tools4j.nobark.loop.IdleStrategy;
import org.tools4j.nobark.loop.Loop;
import org.tools4j.nobark.loop.LoopCondition;
import org.tools4j.nobark.loop.Step;
import org.tools4j.nobark.run.StoppableThread;

public class ElaraLoop
extends Loop {
    private final Runnable initStep;

    public ElaraLoop(LoopCondition loopCondition, IdleStrategy idleStrategy, ExceptionHandler exceptionHandler, Runnable initStep, Step ... steps) {
        super(loopCondition, idleStrategy, exceptionHandler, steps);
        this.initStep = Objects.requireNonNull(initStep);
    }

    public static StoppableThread start(IdleStrategy idleStrategy, ExceptionHandler exceptionHandler, ThreadFactory threadFactory, RunnerFactory runnerFactory) {
        Objects.requireNonNull(idleStrategy);
        Objects.requireNonNull(exceptionHandler);
        Objects.requireNonNull(threadFactory);
        Objects.requireNonNull(runnerFactory);
        return StoppableThread.start(running -> {
            Runnable initStep = runnerFactory.initStep();
            LoopCondition runCondition = runnerFactory.runningCondition();
            Step[] dutyCycle = runnerFactory.dutyCycleWithExtraSteps();
            return new ElaraLoop(workDone -> runCondition.loopAgain(workDone) && running.keepRunning(), idleStrategy, exceptionHandler, initStep, dutyCycle);
        }, (ThreadFactory)threadFactory);
    }

    public void run() {
        this.initStep.run();
        super.run();
    }
}

