/*
 * Decompiled with CFR 0.152.
 */
package org.tools4j.elara.logging;

import java.io.PrintStream;
import java.time.temporal.ChronoField;
import java.util.Objects;
import org.tools4j.elara.logging.Logger;

public class OutputStreamLogger
implements Logger {
    public static final OutputStreamLogger SYSTEM = new OutputStreamLogger();
    public static final Logger.Factory SYSTEM_FACTORY = clazz -> SYSTEM;
    private static final int DAYS_PER_CYCLE = 146097;
    private static final long DAYS_0000_TO_1970 = 719528L;
    private static final long MILLIS_PER_DAY = 86400000L;
    private final Logger.Level level;
    private final PrintStream out;
    private final PrintStream err;

    public OutputStreamLogger() {
        this(Logger.Level.INFO);
    }

    public OutputStreamLogger(Logger.Level level) {
        this(level, System.out, System.err);
    }

    public OutputStreamLogger(Logger.Level level, PrintStream out, PrintStream err) {
        this.level = Objects.requireNonNull(level);
        this.out = Objects.requireNonNull(out);
        this.err = Objects.requireNonNull(err);
    }

    @Override
    public boolean isEnabled(Logger.Level level) {
        return level.ordinal() <= this.level.ordinal();
    }

    @Override
    public void log(Logger.Level level, CharSequence message) {
        OutputStreamLogger.log(level == Logger.Level.ERROR || level == Logger.Level.WARN ? this.err : this.out, level, message);
    }

    private static void log(PrintStream stream, Logger.Level level, CharSequence message) {
        long time = System.currentTimeMillis();
        OutputStreamLogger.printDate(stream, time);
        stream.print('T');
        OutputStreamLogger.printTime(stream, time);
        stream.print('Z');
        stream.print(' ');
        stream.print(OutputStreamLogger.levelString(level));
        stream.print(' ');
        stream.print(message);
        stream.println();
    }

    private static void printDate(PrintStream stream, long epochMillis) {
        long yearEst;
        long doyEst;
        long epochDay = Math.floorDiv(epochMillis, 86400000L);
        long zeroDay = epochDay + 719528L;
        long adjust = 0L;
        if ((zeroDay -= 60L) < 0L) {
            long adjustCycles = (zeroDay + 1L) / 146097L - 1L;
            adjust = adjustCycles * 400L;
            zeroDay += -adjustCycles * 146097L;
        }
        if ((doyEst = zeroDay - (365L * (yearEst = (400L * zeroDay + 591L) / 146097L) + yearEst / 4L - yearEst / 100L + yearEst / 400L)) < 0L) {
            doyEst = zeroDay - (365L * --yearEst + yearEst / 4L - yearEst / 100L + yearEst / 400L);
        }
        yearEst += adjust;
        int marchDoy0 = (int)doyEst;
        int marchMonth0 = (marchDoy0 * 5 + 2) / 153;
        int month = (marchMonth0 + 2) % 12 + 1;
        int dom = marchDoy0 - (marchMonth0 * 306 + 5) / 10 + 1;
        int year = ChronoField.YEAR.checkValidIntValue(yearEst += (long)(marchMonth0 / 10));
        OutputStreamLogger.printDigits(stream, year, 4);
        stream.print('-');
        OutputStreamLogger.printDigits(stream, month, 2);
        stream.print('-');
        OutputStreamLogger.printDigits(stream, dom, 2);
    }

    private static void printTime(PrintStream stream, long epochMillis) {
        int millisOfDay = (int)Math.floorMod(epochMillis, 86400000L);
        int millis = millisOfDay % 1000;
        int seconds = millisOfDay / 1000 % 60;
        int minutes = millisOfDay / 60000 % 60;
        int hours = millisOfDay / 3600000;
        OutputStreamLogger.printDigits(stream, hours, 2);
        stream.print(':');
        OutputStreamLogger.printDigits(stream, minutes, 2);
        stream.print(':');
        OutputStreamLogger.printDigits(stream, seconds, 2);
        stream.print('.');
        OutputStreamLogger.printDigits(stream, millis, 3);
    }

    private static void printDigits(PrintStream stream, int value, int digits) {
        if (value > 0) {
            switch (digits) {
                case 4: {
                    if (value < 1000) {
                        stream.print('0');
                    }
                }
                case 3: {
                    if (value < 100) {
                        stream.print('0');
                    }
                }
                case 2: {
                    if (value >= 10) break;
                    stream.print('0');
                }
            }
        }
        stream.print(value);
    }

    private static String levelString(Logger.Level level) {
        switch (level) {
            case ERROR: {
                return "ERROR";
            }
            case WARN: {
                return " WARN";
            }
            case INFO: {
                return " INFO";
            }
            case DEBUG: {
                return "DEBUG";
            }
        }
        return level.name();
    }
}

