/*
 * Decompiled with CFR 0.152.
 */
package org.tools4j.elara.logging;

import java.util.Objects;
import java.util.function.Consumer;
import org.tools4j.elara.logging.PlaceholderReplacer;

final class FlyweightPlaceholderReplacer
implements PlaceholderReplacer {
    private final StringBuilder temp;
    private Consumer<? super CharSequence> formattedStringConsumer;
    private String message;
    private int start;

    FlyweightPlaceholderReplacer(int initialCapacity) {
        this.temp = new StringBuilder(initialCapacity);
    }

    FlyweightPlaceholderReplacer init(Consumer<? super CharSequence> formattedStringConsumer, String message) {
        this.formattedStringConsumer = Objects.requireNonNull(formattedStringConsumer);
        this.temp.setLength(0);
        this.message = String.valueOf(message);
        this.start = 0;
        return this;
    }

    @Override
    public FlyweightPlaceholderReplacer replace(long arg) {
        int index = this.message.indexOf("{}", this.start);
        if (index >= 0) {
            this.temp.append(this.message, this.start, index);
            this.temp.append(arg);
            this.start = index + "{}".length();
        }
        return this;
    }

    @Override
    public FlyweightPlaceholderReplacer replace(Object arg) {
        int index = this.message.indexOf("{}", this.start);
        if (index >= 0) {
            this.temp.append(this.message, this.start, index);
            this.temp.append(arg);
            this.start = index + "{}".length();
        }
        return this;
    }

    @Override
    public CharSequence format() {
        this.temp.append(this.message, this.start, this.message.length());
        this.formattedStringConsumer.accept(this.temp);
        return this.temp;
    }
}

