/*
 * Decompiled with CFR 0.152.
 */
package org.tools4j.elara.handler;

import java.util.Objects;
import org.tools4j.elara.application.DuplicateHandler;
import org.tools4j.elara.application.EventApplier;
import org.tools4j.elara.application.ExceptionHandler;
import org.tools4j.elara.event.Event;
import org.tools4j.elara.handler.EventHandler;
import org.tools4j.elara.plugin.base.BaseState;

public class DefaultEventHandler
implements EventHandler {
    private final BaseState.Mutable baseState;
    private final EventApplier eventApplier;
    private final ExceptionHandler exceptionHandler;
    private final DuplicateHandler duplicateHandler;

    public DefaultEventHandler(BaseState.Mutable baseState, EventApplier eventApplier, ExceptionHandler exceptionHandler, DuplicateHandler duplicateHandler) {
        this.baseState = Objects.requireNonNull(baseState);
        this.eventApplier = Objects.requireNonNull(eventApplier);
        this.exceptionHandler = Objects.requireNonNull(exceptionHandler);
        this.duplicateHandler = Objects.requireNonNull(duplicateHandler);
    }

    @Override
    public void onEvent(Event event) {
        if (this.baseState.eventApplied(event.id())) {
            this.skipEvent(event);
        } else {
            this.applyEvent(event);
            this.baseState.eventApplied(event);
        }
    }

    private void applyEvent(Event event) {
        try {
            this.eventApplier.onEvent(event);
        }
        catch (Throwable t) {
            this.exceptionHandler.handleEventApplierException(event, t);
        }
    }

    private void skipEvent(Event event) {
        try {
            this.duplicateHandler.skipEventApplying(event);
        }
        catch (Throwable t) {
            this.exceptionHandler.handleEventApplierException(event, t);
        }
    }
}

