/*
 * Decompiled with CFR 0.152.
 */
package org.tools4j.elara.format;

import java.io.PrintWriter;
import java.io.StringWriter;
import java.time.Instant;
import org.tools4j.elara.format.MessagePrinter;
import org.tools4j.elara.format.ParameterizedMessagePrinter;
import org.tools4j.elara.plugin.metrics.FrequencyMetric;
import org.tools4j.elara.plugin.metrics.MetricsLogEntry;
import org.tools4j.elara.plugin.metrics.TimeMetric;

public interface MetricsFormatter
extends org.tools4j.elara.format.ValueFormatter<MetricsLogEntry> {
    public static final MetricsFormatter DEFAULT = new MetricsFormatter(){};
    public static final String VERSION = "{version}";
    public static final String FLAGS = "{flags}";
    public static final String TYPE = "{type}";
    public static final String TARGET = "{target}";
    public static final String SOURCE = "{source}";
    public static final String SEQUENCE = "{sequence}";
    public static final String INDEX = "{index}";
    public static final String TIME = "{time}";
    public static final String CHOICE = "{choice}";
    public static final String REPETITION = "{repetition}";
    public static final String INTERVAL = "{interval}";
    public static final String METRICS_COUNT = "{metrics-count}";
    public static final String METRICS_VALUES = "{metrics-values}";

    default public Object line(long line, long entryId, MetricsLogEntry entry) {
        return line;
    }

    default public Object entryId(long line, long entryId, MetricsLogEntry entry) {
        return entryId;
    }

    default public Object version(long line, long entryId, MetricsLogEntry entry) {
        return entry.version();
    }

    default public Object flags(long line, long entryId, MetricsLogEntry entry) {
        return entry.flags();
    }

    default public Object type(long line, long entryId, MetricsLogEntry entry) {
        MetricsLogEntry.Type type = entry.type();
        switch (entry.type()) {
            case TIME: {
                return "TIME";
            }
            case FREQUENCY: {
                return "FREQ";
            }
        }
        return type;
    }

    default public Object target(long line, long entryId, MetricsLogEntry entry) {
        return entry.target();
    }

    default public Object time(long line, long entryId, MetricsLogEntry entry) {
        return Instant.ofEpochMilli(entry.time());
    }

    default public Object source(long line, long entryId, MetricsLogEntry entry) {
        return entry.source();
    }

    default public Object sequence(long line, long entryId, MetricsLogEntry entry) {
        return entry.sequence();
    }

    default public Object index(long line, long entryId, MetricsLogEntry entry) {
        return entry.index();
    }

    default public Object choice(long line, long entryId, MetricsLogEntry entry) {
        return entry.choice();
    }

    default public Object repetition(long line, long entryId, MetricsLogEntry entry) {
        return entry.repetition();
    }

    default public Object interval(long line, long entryId, MetricsLogEntry entry) {
        return entry.interval();
    }

    default public Object metricsCount(long line, long entryId, MetricsLogEntry entry) {
        return entry.count();
    }

    default public Object metricsValues(long line, long entryId, MetricsLogEntry entry) {
        int count = entry.count();
        StringWriter sw = new StringWriter(count * 16);
        PrintWriter pw = new PrintWriter(sw);
        for (int i = 0; i < count; ++i) {
            MessagePrinter<MetricValue> valuePrinter = this.metricValuePrinter(line, entryId, entry, i);
            MetricValue value = this.metricValue(line, entryId, entry, i);
            valuePrinter.print(line, entryId, value, pw);
        }
        pw.flush();
        return sw.toString();
    }

    @Override
    default public Object value(String placeholder, long line, long entryId, MetricsLogEntry entry) {
        switch (placeholder) {
            case "{nl}": {
                return System.lineSeparator();
            }
            case "{message}": {
                return entry;
            }
            case "{line}": {
                return this.line(line, entryId, entry);
            }
            case "{entry-id}": {
                return this.entryId(line, entryId, entry);
            }
            case "{version}": {
                return this.version(entryId, entryId, entry);
            }
            case "{flags}": {
                return this.flags(entryId, entryId, entry);
            }
            case "{type}": {
                return this.type(entryId, entryId, entry);
            }
            case "{target}": {
                return this.target(entryId, entryId, entry);
            }
            case "{time}": {
                return this.time(entryId, entryId, entry);
            }
            case "{source}": {
                return this.source(entryId, entryId, entry);
            }
            case "{sequence}": {
                return this.sequence(entryId, entryId, entry);
            }
            case "{index}": {
                return this.index(entryId, entryId, entry);
            }
            case "{choice}": {
                return this.choice(entryId, entryId, entry);
            }
            case "{repetition}": {
                return this.repetition(entryId, entryId, entry);
            }
            case "{interval}": {
                return this.interval(entryId, entryId, entry);
            }
            case "{metrics-count}": {
                return this.metricsCount(entryId, entryId, entry);
            }
            case "{metrics-values}": {
                return this.metricsValues(entryId, entryId, entry);
            }
        }
        return placeholder;
    }

    default public MessagePrinter<MetricValue> metricValuePrinter(long line, long entryId, MetricsLogEntry entry, int index) {
        String format = index == 0 ? "{metric-name}={metric-value}" : ", {metric-name}={metric-value}";
        ValueFormatter formatter = this.metricValueFormatter(line, entryId, entry, index);
        return new ParameterizedMessagePrinter<MetricValue>(format, formatter);
    }

    default public ValueFormatter metricValueFormatter(long line, long entryId, MetricsLogEntry entry, int index) {
        return ValueFormatter.DEFAULT;
    }

    default public MetricValue metricValue(long line, long entryId, MetricsLogEntry entry, final int index) {
        MetricsLogEntry.Type type = entry.type();
        final FrequencyMetric name = type == MetricsLogEntry.Type.TIME ? entry.target().metric(entry.flags(), index) : FrequencyMetric.metric(entry.choice(), index);
        final long value = type == MetricsLogEntry.Type.TIME ? entry.time(index) : entry.counter(index);
        return new MetricValue(){

            @Override
            public Enum<?> name() {
                return name;
            }

            @Override
            public long value() {
                return value;
            }

            @Override
            public int index() {
                return index;
            }

            public String toString() {
                return "MetricValue{name=" + name + ", value=" + value + ", index=" + index + "}";
            }
        };
    }

    public static interface ValueFormatter
    extends org.tools4j.elara.format.ValueFormatter<MetricValue> {
        public static final ValueFormatter DEFAULT = new ValueFormatter(){};
        public static final String METRIC_NAME = "{metric-name}";
        public static final String METRIC_VALUE = "{metric-value}";
        public static final String METRIC_INDEX = "{metric-index}";

        default public Object line(long line, long entryId, MetricValue value) {
            return line;
        }

        default public Object entryId(long line, long entryId, MetricValue value) {
            return entryId;
        }

        default public Object metricName(long line, long entryId, MetricValue value) {
            Enum<?> name = value.name();
            if (name instanceof TimeMetric) {
                switch ((TimeMetric)name) {
                    case INPUT_SENDING_TIME: {
                        return "inp-snd";
                    }
                    case INPUT_POLLING_TIME: {
                        return "inp-rcv";
                    }
                    case COMMAND_APPENDING_TIME: {
                        return "cmd-apd";
                    }
                    case COMMAND_POLLING_TIME: {
                        return "cmd-pol";
                    }
                    case PROCESSING_START_TIME: {
                        return "cmd-beg";
                    }
                    case ROUTING_START_TIME: {
                        return "evt-beg";
                    }
                    case ROUTING_END_TIME: {
                        return "evt-rte";
                    }
                    case EVENT_POLLING_TIME: {
                        return "evt-pol";
                    }
                    case OUTPUT_POLLING_TIME: {
                        return "out-pol";
                    }
                    case APPLYING_START_TIME: {
                        return "evt-apy";
                    }
                    case APPLYING_END_TIME: {
                        return "evt-end";
                    }
                    case PROCESSING_END_TIME: {
                        return "cmd-end";
                    }
                    case OUTPUT_START_TIME: {
                        return "out-pub";
                    }
                    case OUTPUT_END_TIME: {
                        return "out-end";
                    }
                    case METRIC_APPENDING_TIME: {
                        return "met-apd";
                    }
                }
            } else if (name instanceof FrequencyMetric) {
                switch ((FrequencyMetric)name) {
                    case DUTY_CYCLE_FREQUENCY: {
                        return "cyc-all";
                    }
                    case INPUTS_POLL_FREQUENCY: {
                        return "inp-all";
                    }
                    case COMMAND_POLL_FREQUENCY: {
                        return "cmd-all";
                    }
                    case EVENT_POLL_FREQUENCY: {
                        return "evt-all";
                    }
                    case OUTPUT_POLL_FREQUENCY: {
                        return "out-all";
                    }
                    case EXTRA_STEP_INVOCATION_FREQUENCY: {
                        return "xta-all";
                    }
                    case DUTY_CYCLE_PERFORMED_FREQUENCY: {
                        return "cyc-prf";
                    }
                    case INPUT_RECEIVED_FREQUENCY: {
                        return "inp-rcv";
                    }
                    case COMMAND_PROCESSED_FREQUENCY: {
                        return "cmd-prc";
                    }
                    case EVENT_APPLIED_FREQUENCY: {
                        return "evt-apy";
                    }
                    case OUTPUT_PUBLISHED_FREQUENCY: {
                        return "out-pub";
                    }
                    case EXTRA_STEP_PERFORMED_FREQUENCY: {
                        return "xta-prf";
                    }
                    case STEP_ERROR_FREQUENCY: {
                        return "stp-err";
                    }
                }
            }
            return name;
        }

        default public Object metricValue(long line, long entryId, MetricValue value) {
            return value.value();
        }

        default public Object metricIndex(long line, long entryId, MetricValue value) {
            return value.index();
        }

        @Override
        default public Object value(String placeholder, long line, long entryId, MetricValue value) {
            switch (placeholder) {
                case "{nl}": {
                    return System.lineSeparator();
                }
                case "{message}": {
                    return value;
                }
                case "{line}": {
                    return this.line(line, entryId, value);
                }
                case "{entry-id}": {
                    return this.entryId(line, entryId, value);
                }
                case "{metric-name}": {
                    return this.metricName(line, entryId, value);
                }
                case "{metric-value}": {
                    return this.metricValue(line, entryId, value);
                }
                case "{metric-index}": {
                    return this.metricIndex(line, entryId, value);
                }
            }
            return placeholder;
        }
    }

    public static interface MetricValue {
        public Enum<?> name();

        public long value();

        public int index();
    }
}

