/*
 * Decompiled with CFR 0.152.
 */
package org.tools4j.elara.format;

import java.util.Objects;
import org.tools4j.elara.flyweight.DataFrame;
import org.tools4j.elara.format.DataFrameFormatter;
import org.tools4j.elara.format.MessagePrinter;
import org.tools4j.elara.format.MetricsFormatter;
import org.tools4j.elara.format.Spacer;
import org.tools4j.elara.format.ValueFormatter;
import org.tools4j.elara.plugin.metrics.MetricsLogEntry;
import org.tools4j.elara.plugin.metrics.TimeMetric;

public enum MessagePrinters {

    public static final String VERSION_LINE = "(elara message log format V{version}){nl}";
    public static final String GENERAL_FORMAT = "{line}: {message}{nl}";
    public static final String PIPE_FORMAT = "{line}: src={source}|tp={type}}|sq={sequence}|tm={time}}|vr={version}|ix={index}|sz={payload-size}{nl}";
    public static final String SHORT_FORMAT = "{line}: src={source}, tp={type}, sq={sequence}, tm={time}, vs={version}, ix={index}, sz={payload-size}{nl}";
    public static final String LONG_FORMAT = "{line}: source={source}, type={type}, sequence={sequence}, time={time}, version={version}, index={index}, size={payload-size}{nl}";
    public static final String COMMAND_FORMAT = "{time} | {line} - cmd={source}:{sequence} | type={type}, payload({payload-size})={payload}{nl}";
    public static final String EVENT_FORMAT_0 = "{time} | {line} - evt={source}:{sequence}.{index} | type={type}, payload({payload-size})={payload}{nl}";
    public static final String EVENT_FORMAT_N = "{time} | {line} - evt={source}.{sequence}.{index} | type={type}, payload({payload-size})={payload}{nl}";
    public static final String METRICS_VERSION_LINE = "(elara metrics log format V{version}){nl}";
    public static final String METRICS_COMMAND_FORMAT = "{time} | {line} - {type} cmd={source}:{sequence}   | {metrics-values}{nl}";
    public static final String METRICS_EVENT_FORMAT_0 = "{time} | {line} - {type} evt={source}:{sequence}.{index} | {metrics-values}{nl}";
    public static final String METRICS_EVENT_FORMAT_N = "{time} | {line} - {type} evt={source}.{sequence}.{index} | {metrics-values}{nl}";
    public static final String METRICS_OUTPUT_FORMAT_0 = "{time} | {line} - {type} evt={source}:{sequence}.{index} | {metrics-values}{nl}";
    public static final String METRICS_OUTPUT_FORMAT_N = "{time} | {line} - {type} evt={source}.{sequence}.{index} | {metrics-values}{nl}";
    public static final String METRICS_FREQUENCY_FORMAT = "{time} | {line} - {type} rep={repetition}, intvl={interval} | {metrics-values}{nl}";
    public static final String METRICS_VALUE_FORMAT_0 = "{metric-name}={metric-value}";
    public static final String METRICS_VALUE_FORMAT_N = ", {metric-name}={metric-value}";
    public static final MessagePrinter<Object> GENERAL = MessagePrinter.parameterized("{line}: {message}{nl}", ValueFormatter.DEFAULT);
    public static final MessagePrinter<DataFrame> PIPE = MessagePrinter.parameterized("{line}: src={source}|tp={type}}|sq={sequence}|tm={time}}|vr={version}|ix={index}|sz={payload-size}{nl}", DataFrameFormatter.DEFAULT);
    public static final MessagePrinter<DataFrame> SHORT = MessagePrinter.parameterized("{line}: src={source}, tp={type}, sq={sequence}, tm={time}, vs={version}, ix={index}, sz={payload-size}{nl}", DataFrameFormatter.DEFAULT);
    public static final MessagePrinter<DataFrame> LONG = MessagePrinter.parameterized("{line}: source={source}, type={type}, sequence={sequence}, time={time}, version={version}, index={index}, size={payload-size}{nl}", DataFrameFormatter.DEFAULT);
    public static final MessagePrinter<DataFrame> COMMAND = MessagePrinters.command(DataFrameFormatter.DEFAULT);
    public static final MessagePrinter<DataFrame> EVENT = MessagePrinters.event(DataFrameFormatter.DEFAULT);
    public static final MessagePrinter<DataFrame> FRAME = MessagePrinters.frame(DataFrameFormatter.DEFAULT);
    public static final MessagePrinter<MetricsLogEntry> METRICS = MessagePrinters.metrics(MetricsFormatter.DEFAULT);

    public static MessagePrinter<DataFrame> command(DataFrameFormatter formatter) {
        Objects.requireNonNull(formatter);
        return MessagePrinter.composite((line, entryId, frame) -> line == 0L ? 0 : 1, MessagePrinter.parameterized("(elara message log format V{version}){nl}{time} | {line} - cmd={source}:{sequence} | type={type}, payload({payload-size})={payload}{nl}", formatter), MessagePrinter.parameterized(COMMAND_FORMAT, formatter));
    }

    public static MessagePrinter<DataFrame> event(DataFrameFormatter formatter) {
        DataFrameFormatter formatter0 = formatter;
        ValueFormatter<DataFrame> formatterN = Spacer.spacer(formatter, '.', "{source}", "{sequence}");
        return MessagePrinter.composite((line, entryId, frame) -> {
            if (line == 0L) {
                return 0;
            }
            if (frame.header().index() == 0) {
                return 1;
            }
            return 2;
        }, MessagePrinter.parameterized("(elara message log format V{version}){nl}{time} | {line} - evt={source}:{sequence}.{index} | type={type}, payload({payload-size})={payload}{nl}", formatter0), MessagePrinter.parameterized(EVENT_FORMAT_0, formatter0), MessagePrinter.parameterized(EVENT_FORMAT_N, formatterN));
    }

    public static MessagePrinter<DataFrame> frame(DataFrameFormatter formatter) {
        return MessagePrinter.composite((line, entryId, frame) -> frame.header().index() == Short.MIN_VALUE ? 0 : 1, MessagePrinters.command(formatter), MessagePrinters.event(formatter));
    }

    public static MessagePrinter<MetricsLogEntry> timeMetrics(MetricsFormatter formatter) {
        MetricsFormatter formatter0 = formatter;
        ValueFormatter<MetricsLogEntry> formatterN = Spacer.spacer(formatter, '.', "{source}", "{sequence}");
        return MessagePrinter.composite((line, entryId, entry) -> {
            TimeMetric.Target target = entry.target();
            switch (target) {
                case COMMAND: {
                    return line == 0L ? 0 : 1;
                }
                case EVENT: {
                    return line == 0L ? 2 : (entry.index() == 0 ? 3 : 4);
                }
                case OUTPUT: {
                    return line == 0L ? 5 : (entry.index() == 0 ? 6 : 7);
                }
            }
            throw new IllegalArgumentException("Invalid target: " + (Object)((Object)target));
        }, MessagePrinter.parameterized("(elara metrics log format V{version}){nl}{time} | {line} - {type} cmd={source}:{sequence}   | {metrics-values}{nl}", formatter0), MessagePrinter.parameterized(METRICS_COMMAND_FORMAT, formatter0), MessagePrinter.parameterized("(elara metrics log format V{version}){nl}{time} | {line} - {type} evt={source}:{sequence}.{index} | {metrics-values}{nl}", formatter0), MessagePrinter.parameterized("{time} | {line} - {type} evt={source}:{sequence}.{index} | {metrics-values}{nl}", formatter0), MessagePrinter.parameterized("{time} | {line} - {type} evt={source}.{sequence}.{index} | {metrics-values}{nl}", formatterN), MessagePrinter.parameterized("(elara metrics log format V{version}){nl}{time} | {line} - {type} evt={source}:{sequence}.{index} | {metrics-values}{nl}", formatter0), MessagePrinter.parameterized("{time} | {line} - {type} evt={source}:{sequence}.{index} | {metrics-values}{nl}", formatter0), MessagePrinter.parameterized("{time} | {line} - {type} evt={source}.{sequence}.{index} | {metrics-values}{nl}", formatterN));
    }

    public static MessagePrinter<MetricsLogEntry> frequencyMetrics(MetricsFormatter formatter) {
        Objects.requireNonNull(formatter);
        return MessagePrinter.composite((line, entryId, frame) -> line == 0L ? 0 : 1, MessagePrinter.parameterized("(elara metrics log format V{version}){nl}{time} | {line} - {type} rep={repetition}, intvl={interval} | {metrics-values}{nl}", formatter), MessagePrinter.parameterized(METRICS_FREQUENCY_FORMAT, formatter));
    }

    public static MessagePrinter<MetricsLogEntry> metrics(MetricsFormatter formatter) {
        return MessagePrinter.composite((line, entryId, emtry) -> emtry.type() == MetricsLogEntry.Type.TIME ? 0 : 1, MessagePrinters.timeMetrics(formatter), MessagePrinters.frequencyMetrics(formatter));
    }
}

