/*
 * Decompiled with CFR 0.152.
 */
package org.tools4j.elara.format;

import org.agrona.DirectBuffer;

public enum Hex {

    private static final char[] HEX_CHARS = new char[]{'0', '1', '2', '3', '4', '5', '6', '7', '8', '9', 'a', 'b', 'c', 'd', 'e', 'f'};
    private static final char BYTE_SPACER = ' ';
    private static final String[] DECIMAL_SEPACERS = new String[]{" : ", " :: ", " ::: "};

    public static String hex(DirectBuffer buffer) {
        return Hex.hex(buffer, 0, buffer.capacity());
    }

    public static String hex(DirectBuffer buffer, int offset, int length) {
        return Hex.hex(buffer, offset, length, true, true);
    }

    public static String hex(DirectBuffer buffer, int offset, int length, boolean byteSeparators, boolean decimalSeparators) {
        StringBuilder sb = new StringBuilder(length * 3);
        for (int i = 0; i < length; ++i) {
            byte b = buffer.getByte(offset + i);
            int b0 = b & 0xF;
            int b1 = b >>> 4 & 0xF;
            if (i > 0) {
                Hex.appendSpacer(sb, i, byteSeparators, decimalSeparators);
            }
            sb.append(HEX_CHARS[b0]);
            sb.append(HEX_CHARS[b1]);
        }
        return sb.toString();
    }

    private static void appendSpacer(StringBuilder sb, int index, boolean byteSeparators, boolean decimalSeparators) {
        if (decimalSeparators && index % 10 == 0) {
            if (index % 100 == 0) {
                sb.append(index % 1000 == 0 ? DECIMAL_SEPACERS[2] : DECIMAL_SEPACERS[1]);
            } else {
                sb.append(DECIMAL_SEPACERS[0]);
            }
        } else if (byteSeparators) {
            sb.append(' ');
        }
    }
}

