/*
 * Decompiled with CFR 0.152.
 */
package org.tools4j.elara.format;

import java.io.PrintWriter;
import java.util.Objects;
import org.tools4j.elara.format.MessagePrinter;

public class CompositeMessagePrinter<M>
implements MessagePrinter<M> {
    private final PrinterProvider<M> printerProvider;

    public CompositeMessagePrinter(PrinterProvider<M> printerProvider) {
        this.printerProvider = Objects.requireNonNull(printerProvider);
    }

    public CompositeMessagePrinter(PrinterSelector<M> printerSelector, MessagePrinter<? super M> ... printers) {
        this((line, entryId, message) -> printers[printerSelector.select(line, entryId, message)]);
    }

    @Override
    public void print(long line, long entryId, M message, PrintWriter writer) {
        this.printerProvider.provide(line, entryId, message).print(line, entryId, message, writer);
    }

    @FunctionalInterface
    public static interface PrinterSelector<M> {
        public int select(long var1, long var3, M var5);
    }

    @FunctionalInterface
    public static interface PrinterProvider<M> {
        public MessagePrinter<? super M> provide(long var1, long var3, M var5);
    }
}

