/*
 * Decompiled with CFR 0.152.
 */
package org.tools4j.elara.flyweight;

import org.agrona.DirectBuffer;
import org.agrona.MutableDirectBuffer;
import org.tools4j.elara.command.Command;
import org.tools4j.elara.event.Event;
import org.tools4j.elara.flyweight.DataFrame;
import org.tools4j.elara.flyweight.Flags;
import org.tools4j.elara.flyweight.Flyweight;
import org.tools4j.elara.flyweight.FlyweightDataFrame;
import org.tools4j.elara.flyweight.Header;

public class FlyweightEvent
implements Flyweight<FlyweightEvent>,
Event,
Event.Id,
Command.Id,
DataFrame {
    private final FlyweightDataFrame frame = new FlyweightDataFrame();
    private final Event.Flags flags = new FlyweightFlags();

    public FlyweightEvent init(MutableDirectBuffer header, int headerOffset, int source, long sequence, short index, int type, long time, byte flags, DirectBuffer payload, int payloadOffset, int payloadSize) {
        this.frame.init(header, headerOffset, source, type, sequence, time, flags, index, payload, payloadOffset, payloadSize);
        return this;
    }

    public FlyweightEvent init(DirectBuffer header, int headerOffset, DirectBuffer payload, int payloadOffset, int payloadSize) {
        this.frame.init(header, headerOffset, payload, payloadOffset, payloadSize);
        return this;
    }

    @Override
    public FlyweightEvent init(DirectBuffer event, int offset) {
        this.frame.init(event, offset);
        return this;
    }

    public boolean valid() {
        return this.frame.valid();
    }

    public FlyweightEvent reset() {
        this.frame.reset();
        return this;
    }

    @Override
    public Header header() {
        return this.frame.header();
    }

    @Override
    public Event.Id id() {
        return this;
    }

    @Override
    public Command.Id commandId() {
        return this;
    }

    @Override
    public Event.Flags flags() {
        return this.flags;
    }

    @Override
    public int source() {
        return this.header().source();
    }

    @Override
    public long sequence() {
        return this.header().sequence();
    }

    @Override
    public int index() {
        return this.header().index();
    }

    @Override
    public int type() {
        return this.header().type();
    }

    @Override
    public long time() {
        return this.header().time();
    }

    @Override
    public DirectBuffer payload() {
        return this.frame.payload();
    }

    @Override
    public int writeTo(MutableDirectBuffer dst, int dstOffset) {
        return this.frame.writeTo(dst, dstOffset);
    }

    public String toString() {
        return this.valid() ? "FlyweightEvent{source=" + this.source() + ", type=" + this.type() + ", sequence=" + this.sequence() + ", time=" + this.time() + ", version=" + this.header().version() + ", flags=" + Flags.toString(this.header().flags()) + ", index=" + this.index() + ", payload-size=" + this.header().payloadSize() + '}' : "FlyweightEvent";
    }

    private final class FlyweightFlags
    implements Event.Flags {
        private FlyweightFlags() {
        }

        @Override
        public boolean isCommit() {
            return Flags.isCommit(this.value());
        }

        @Override
        public boolean isRollback() {
            return Flags.isRollback(this.value());
        }

        @Override
        public boolean isFinal() {
            return Flags.isFinal(this.value());
        }

        @Override
        public boolean isNonFinal() {
            return Flags.isNonFinal(this.value());
        }

        @Override
        public byte value() {
            return FlyweightEvent.this.header().flags();
        }

        public String toString() {
            return Flags.toString(this.value());
        }
    }
}

