/*
 * Decompiled with CFR 0.152.
 */
package org.tools4j.elara.factory;

import java.util.Arrays;
import java.util.Objects;
import java.util.function.Supplier;
import org.tools4j.elara.application.EventApplier;
import org.tools4j.elara.event.CompositeEventApplier;
import org.tools4j.elara.factory.ApplierFactory;
import org.tools4j.elara.factory.Singletons;
import org.tools4j.elara.handler.DefaultEventHandler;
import org.tools4j.elara.handler.EventHandler;
import org.tools4j.elara.init.Configuration;
import org.tools4j.elara.loop.EventPollerStep;
import org.tools4j.elara.plugin.api.Plugin;
import org.tools4j.elara.plugin.base.BaseState;
import org.tools4j.nobark.loop.Step;

public class DefaultApplierFactory
implements ApplierFactory {
    private final Configuration configuration;
    private final Supplier<? extends Singletons> singletons;

    public DefaultApplierFactory(Configuration configuration, Supplier<? extends Singletons> singletons) {
        this.configuration = Objects.requireNonNull(configuration);
        this.singletons = Objects.requireNonNull(singletons);
    }

    @Override
    public EventApplier eventApplier() {
        EventApplier eventApplier = this.configuration.eventApplier();
        Plugin.Configuration[] plugins = this.singletons.get().plugins();
        if (plugins.length == 0) {
            return eventApplier;
        }
        BaseState.Mutable baseState = this.singletons.get().baseState();
        EventApplier[] appliers = new EventApplier[plugins.length + 1];
        int count = 0;
        for (Plugin.Configuration plugin : plugins) {
            appliers[count] = plugin.eventApplier(baseState);
            if (appliers[count] == EventApplier.NOOP) continue;
            ++count;
        }
        if (count == 0) {
            return eventApplier;
        }
        appliers[count++] = eventApplier;
        return new CompositeEventApplier(count == appliers.length ? appliers : Arrays.copyOf(appliers, count));
    }

    @Override
    public EventHandler eventHandler() {
        return new DefaultEventHandler(this.singletons.get().baseState(), this.singletons.get().eventApplier(), this.configuration.exceptionHandler(), this.configuration.duplicateHandler());
    }

    @Override
    public Step eventPollerStep() {
        return new EventPollerStep(this.configuration.eventLog().poller(), this.singletons.get().eventHandler());
    }
}

