/*
 * Decompiled with CFR 0.152.
 */
package org.tools4j.elara.application;

import org.tools4j.elara.command.Command;
import org.tools4j.elara.event.Event;
import org.tools4j.elara.logging.ElaraLogger;
import org.tools4j.elara.logging.Logger;
import org.tools4j.elara.logging.OutputStreamLogger;

@FunctionalInterface
public interface DuplicateHandler {
    public static final DuplicateHandler DEFAULT = DuplicateHandler.loggingHandler(OutputStreamLogger.SYSTEM_FACTORY);
    public static final DuplicateHandler NOOP = command -> {};

    public void skipCommandProcessing(Command var1);

    default public void skipEventApplying(Event event) {
    }

    public static DuplicateHandler loggingHandler(Logger.Factory loggerFactory) {
        final ElaraLogger logger = ElaraLogger.create(loggerFactory, DuplicateHandler.class);
        return new DuplicateHandler(){

            @Override
            public void skipCommandProcessing(Command command) {
                if (logger.isEnabled(Logger.Level.INFO)) {
                    logger.info("Skipping command: {}").replace(command).format();
                }
            }

            @Override
            public void skipEventApplying(Event event) {
                if (logger.isEnabled(Logger.Level.DEBUG)) {
                    logger.debug("Skipping event: {}").replace(event).format();
                }
            }
        };
    }
}

