/*
 * Decompiled with CFR 0.152.
 */
package org.tools4j.elara.run;

import java.util.Objects;
import org.agrona.concurrent.IdleStrategy;
import org.tools4j.elara.factory.ElaraFactory;
import org.tools4j.elara.init.Configuration;
import org.tools4j.elara.init.Context;
import org.tools4j.elara.loop.ElaraLoop;
import org.tools4j.elara.run.ElaraRunner;
import org.tools4j.nobark.run.ThreadLike;

public enum Elara {


    public static ElaraRunner launch(Context context) {
        return Elara.launch((Configuration)context.populateDefaults());
    }

    public static ElaraRunner launch(Configuration configuration) {
        return Elara.launch(ElaraFactory.create(configuration));
    }

    public static ElaraRunner launch(ElaraFactory elaraFactory) {
        Configuration configuration = elaraFactory.configuration();
        return new ElaraRunner((ThreadLike)ElaraLoop.start(Elara.nobarkIdleStrategy(configuration.idleStrategy()), configuration.exceptionHandler(), configuration.threadFactory(), elaraFactory.singletons()));
    }

    private static org.tools4j.nobark.loop.IdleStrategy nobarkIdleStrategy(final IdleStrategy idleStrategy) {
        Objects.requireNonNull(idleStrategy);
        return new org.tools4j.nobark.loop.IdleStrategy(){

            public void idle() {
                idleStrategy.idle();
            }

            public void reset() {
                idleStrategy.reset();
            }

            public void idle(boolean workDone) {
                idleStrategy.idle(workDone ? 1 : 0);
            }

            public String toString() {
                return idleStrategy.toString();
            }
        };
    }
}

