/*
 * Decompiled with CFR 0.152.
 */
package org.tools4j.elara.route;

import java.util.Objects;
import org.agrona.DirectBuffer;
import org.agrona.MutableDirectBuffer;
import org.tools4j.elara.application.EventApplier;
import org.tools4j.elara.command.Command;
import org.tools4j.elara.flyweight.FlyweightEvent;
import org.tools4j.elara.flyweight.FlyweightHeader;
import org.tools4j.elara.log.ExpandableDirectBuffer;
import org.tools4j.elara.log.MessageLog;
import org.tools4j.elara.route.EventRouter;

public class DefaultEventRouter
implements EventRouter.Default {
    private static final int MAX_EVENTS = 32768;
    private final MessageLog.Appender appender;
    private final EventApplier eventApplier;
    private final RoutingContext routingContext = new RoutingContext();
    private Command command;
    private short nextIndex;
    private boolean skipped;

    public DefaultEventRouter(MessageLog.Appender appender, EventApplier eventApplier) {
        this.appender = Objects.requireNonNull(appender);
        this.eventApplier = Objects.requireNonNull(eventApplier);
    }

    public DefaultEventRouter start(Command command) {
        this.command = Objects.requireNonNull(command);
        this.nextIndex = 0;
        this.skipped = false;
        return this;
    }

    @Override
    public RoutingContext routingEvent(int type) {
        DefaultEventRouter.checkEventType(type);
        this.checkNotSkipped();
        this.checkEventLimit();
        return this.routingEvent0(type);
    }

    private RoutingContext routingEvent0(int type) {
        if (this.nextIndex > 0 && this.routingContext.isCommitPending()) {
            this.routingContext.commit((byte)0);
        }
        return this.routingContext.init(type, this.appender.appending());
    }

    public void complete() {
        if (!this.skipped) {
            if (this.nextIndex == 0 || !this.routingContext.isCommitPending()) {
                this.routeCommitEvent();
            }
            this.routingContext.commit((byte)1);
        }
        this.command = null;
        this.skipped = false;
        this.nextIndex = 0;
    }

    private void routeCommitEvent() {
        try (RoutingContext context = this.routingEvent0(-1);){
            context.route(0);
        }
    }

    @Override
    public boolean skipCommand() {
        if (this.skipped) {
            return true;
        }
        if (this.nextIndex > 0) {
            return false;
        }
        if (this.routingContext.isCommitPending()) {
            this.routingContext.abort();
        }
        this.skipped = true;
        return this.skipped;
    }

    @Override
    public boolean isSkipped() {
        return this.skipped;
    }

    @Override
    public short nextEventIndex() {
        return this.nextIndex;
    }

    private static void checkEventType(int eventType) {
        if (eventType == -1 || eventType == -2) {
            throw new IllegalArgumentException("Illegal event type: " + eventType);
        }
    }

    private void checkNotSkipped() {
        if (this.skipped) {
            throw new IllegalStateException("Command has been skipped and event routing is not possible");
        }
    }

    private void checkEventLimit() {
        if ((0xFFFF & this.nextIndex) >= 32768) {
            throw new IllegalStateException("Maximum number of events per command reached: 32768");
        }
    }

    private final class RoutingContext
    implements EventRouter.RoutingContext {
        final FlyweightEvent flyweightEvent = new FlyweightEvent();
        final ExpandableDirectBuffer buffer = new ExpandableDirectBuffer();
        MessageLog.AppendingContext context;

        private RoutingContext() {
        }

        RoutingContext init(int type, MessageLog.AppendingContext context) {
            if (this.context != null) {
                this.abort();
                throw new IllegalStateException("Routing context not closed");
            }
            this.context = Objects.requireNonNull(context);
            this.buffer.wrap(context.buffer(), 32);
            FlyweightHeader.writeTo(DefaultEventRouter.this.command.id().source(), type, DefaultEventRouter.this.command.id().sequence(), DefaultEventRouter.this.command.time(), (byte)0, DefaultEventRouter.this.nextIndex, 0, context.buffer(), 0);
            return this;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        void commit(byte flags) {
            try (MessageLog.AppendingContext ac = this.unclosedContext();){
                if (flags != 0) {
                    ac.buffer().putByte(25, flags);
                }
                int payloadLength = ac.buffer().getInt(28);
                ac.commit(32 + payloadLength);
            }
            finally {
                this.context = null;
            }
        }

        MessageLog.AppendingContext unclosedContext() {
            if (this.context != null) {
                return this.context;
            }
            throw new IllegalStateException("Routing context is closed");
        }

        @Override
        public int index() {
            this.unclosedContext();
            return DefaultEventRouter.this.nextIndex;
        }

        @Override
        public MutableDirectBuffer buffer() {
            this.unclosedContext();
            return this.buffer;
        }

        @Override
        public void route(int length) {
            if (length < 0) {
                throw new IllegalArgumentException("Length cannot be negative: " + length);
            }
            MessageLog.AppendingContext ac = this.unclosedContext();
            this.buffer.unwrap();
            if (length > 0) {
                ac.buffer().putInt(28, length);
            }
            this.flyweightEvent.init((DirectBuffer)ac.buffer(), 0);
            DefaultEventRouter.this.eventApplier.onEvent(this.flyweightEvent);
            this.flyweightEvent.reset();
            DefaultEventRouter.this.nextIndex = (short)(DefaultEventRouter.this.nextIndex + 1);
        }

        @Override
        public void abort() {
            if (this.context != null) {
                this.buffer.unwrap();
                this.flyweightEvent.reset();
                try {
                    this.context.abort();
                }
                finally {
                    this.context = null;
                }
            }
        }

        @Override
        public boolean isClosed() {
            return this.context == null || this.buffer.buffer() == null;
        }

        boolean isCommitPending() {
            return this.buffer.buffer() == null && this.context != null;
        }
    }
}

