/*
 * Decompiled with CFR 0.152.
 */
package org.tools4j.elara.plugin.timer;

import java.util.Objects;
import org.tools4j.elara.input.Input;
import org.tools4j.elara.input.Receiver;
import org.tools4j.elara.input.SequenceGenerator;
import org.tools4j.elara.input.SimpleSequenceGenerator;
import org.tools4j.elara.plugin.timer.TimerCommands;
import org.tools4j.elara.plugin.timer.TimerState;
import org.tools4j.elara.time.TimeSource;

public final class TimerTriggerInput
implements Input {
    private final int source;
    private final TimeSource timeSource;
    private final TimerState timerState;
    private final SequenceGenerator sequenceGenerator = new SimpleSequenceGenerator();
    private boolean timerTriggerPending;

    public TimerTriggerInput(int source, TimeSource timeSource, TimerState timerState) {
        if (source == -1) {
            throw new IllegalArgumentException("Source -1 is reserved for loopback");
        }
        this.source = source;
        this.timeSource = Objects.requireNonNull(timeSource);
        this.timerState = Objects.requireNonNull(timerState);
    }

    void timerEventApplied() {
        this.timerTriggerPending = false;
    }

    @Override
    public int poll(Receiver receiver) {
        if (this.timerTriggerPending) {
            return 0;
        }
        int next = this.timerState.indexOfNextDeadline();
        if (next >= 0 && this.timerState.deadline(next) <= this.timeSource.currentTime()) {
            long seq = this.sequenceGenerator.nextSequence();
            try (Receiver.ReceivingContext context = receiver.receivingMessage(this.source, seq, -10);){
                int length = TimerCommands.triggerTimer(context.buffer(), 0, this.timerState.id(next), this.timerState.type(next), this.timerState.repetition(next), this.timerState.timeout(next));
                context.receive(length);
                this.timerTriggerPending = true;
            }
            return 1;
        }
        return 0;
    }
}

