/*
 * Decompiled with CFR 0.152.
 */
package org.tools4j.elara.plugin.timer;

import java.util.Objects;
import org.tools4j.elara.application.CommandProcessor;
import org.tools4j.elara.application.EventApplier;
import org.tools4j.elara.init.Configuration;
import org.tools4j.elara.input.Input;
import org.tools4j.elara.plugin.api.Plugin;
import org.tools4j.elara.plugin.api.SystemPlugin;
import org.tools4j.elara.plugin.api.TypeRange;
import org.tools4j.elara.plugin.base.BaseState;
import org.tools4j.elara.plugin.timer.SimpleTimerState;
import org.tools4j.elara.plugin.timer.TimerCommandProcessor;
import org.tools4j.elara.plugin.timer.TimerEventApplier;
import org.tools4j.elara.plugin.timer.TimerState;
import org.tools4j.elara.plugin.timer.TimerTriggerInput;

public class TimerPlugin
implements SystemPlugin<TimerState.Mutable> {
    public static final int DEFAULT_COMMAND_SOURCE = -10;
    public static final TimerPlugin DEFAULT = new TimerPlugin(-10);
    private final int commandSource;

    public TimerPlugin(int commandSource) {
        this.commandSource = commandSource;
    }

    @Override
    public TypeRange typeRange() {
        return TypeRange.TIMER;
    }

    @Override
    public TimerState.Mutable defaultPluginState() {
        return new SimpleTimerState();
    }

    @Override
    public Plugin.Configuration configuration(final Configuration appConfig, final TimerState.Mutable timerState) {
        Objects.requireNonNull(appConfig);
        Objects.requireNonNull(timerState);
        return new Plugin.Configuration.Default(){
            final TimerTriggerInput timerTrigger;
            {
                this.timerTrigger = new TimerTriggerInput(TimerPlugin.this.commandSource, appConfig.timeSource(), timerState);
            }

            @Override
            public Input[] inputs(BaseState baseState) {
                return new Input[]{this.timerTrigger};
            }

            @Override
            public CommandProcessor commandProcessor(BaseState baseState) {
                return new TimerCommandProcessor(timerState);
            }

            @Override
            public EventApplier eventApplier(BaseState.Mutable baseState) {
                return new TimerEventApplier(timerState, this.timerTrigger);
            }
        };
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        TimerPlugin that = (TimerPlugin)o;
        return this.commandSource == that.commandSource;
    }

    public int hashCode() {
        return Objects.hash(this.commandSource);
    }
}

