/*
 * Decompiled with CFR 0.152.
 */
package org.tools4j.elara.plugin.timer;

import org.agrona.DirectBuffer;
import org.agrona.MutableDirectBuffer;
import org.tools4j.elara.command.Command;
import org.tools4j.elara.event.Event;
import org.tools4j.elara.flyweight.Frame;
import org.tools4j.elara.plugin.timer.TimerPayloadDescriptor;
import org.tools4j.elara.route.EventRouter;

public enum TimerEvents {

    public static final int TIMER_FIRED = -10;
    public static final int TIMER_EXPIRED = -11;
    public static final int TIMER_STARTED = -12;
    public static final int TIMER_STOPPED = -13;

    public static void routeTimerStarted(long timerId, int timerType, long timeout, EventRouter eventRouter) {
        try (EventRouter.RoutingContext context = eventRouter.routingEvent(-12);){
            context.route(TimerEvents.timerStarted(context.buffer(), 0, timerId, timerType, timeout));
        }
    }

    public static void routePeriodicStarted(long timerId, int timerType, long timeout, EventRouter eventRouter) {
        try (EventRouter.RoutingContext context = eventRouter.routingEvent(-12);){
            context.route(TimerEvents.periodicStarted(context.buffer(), 0, timerId, timerType, timeout));
        }
    }

    public static void routeTimerStopped(long timerId, int timerType, int repetition, long timeout, EventRouter eventRouter) {
        try (EventRouter.RoutingContext context = eventRouter.routingEvent(-13);){
            context.route(TimerEvents.timerStopped(context.buffer(), 0, timerId, timerType, repetition, timeout));
        }
    }

    public static int timerStarted(MutableDirectBuffer buffer, int offset, long timerId, int timerType, long timeout) {
        return TimerEvents.timerEvent(buffer, offset, timerId, timerType, -1, timeout);
    }

    public static int periodicStarted(MutableDirectBuffer buffer, int offset, long timerId, int timerType, long timeout) {
        return TimerEvents.timerEvent(buffer, offset, timerId, timerType, 0, timeout);
    }

    public static int timerStopped(MutableDirectBuffer buffer, int offset, long timerId, int timerType, int repetition, long timeout) {
        return TimerEvents.timerEvent(buffer, offset, timerId, timerType, repetition, timeout);
    }

    public static int timerFired(MutableDirectBuffer buffer, int offset, Command command) {
        return TimerEvents.timerTriggered(buffer, offset, command);
    }

    public static int timerExpired(MutableDirectBuffer buffer, int offset, Command command) {
        return TimerEvents.timerTriggered(buffer, offset, command);
    }

    private static int timerTriggered(MutableDirectBuffer buffer, int offset, Command command) {
        if (command.type() != -10) {
            throw new IllegalArgumentException("Expected -10 command but found " + command.type());
        }
        DirectBuffer payload = command.payload();
        buffer.putBytes(offset, payload, 0, payload.capacity());
        return payload.capacity();
    }

    private static int timerEvent(MutableDirectBuffer buffer, int offset, long timerId, int timerType, int repetition, long timeout) {
        buffer.putLong(offset + 0, timerId);
        buffer.putInt(offset + 8, timerType);
        buffer.putInt(offset + 12, repetition);
        buffer.putLong(offset + 16, timeout);
        return 24;
    }

    public static long timerId(Event event) {
        return TimerPayloadDescriptor.timerId(event.payload());
    }

    public static int timerType(Event event) {
        return TimerPayloadDescriptor.timerType(event.payload());
    }

    public static int timerRepetition(Event event) {
        return TimerPayloadDescriptor.timerRepetition(event.payload());
    }

    public static long timerTimeout(Event event) {
        return TimerPayloadDescriptor.timerTimeout(event.payload());
    }

    public static boolean isTimerEvent(Event event) {
        return TimerEvents.isTimerEventType(event.type());
    }

    public static boolean isTimerEvent(Frame frame) {
        return frame.header().index() >= 0 && TimerEvents.isTimerEventType(frame.header().type());
    }

    public static boolean isTimerEventType(int eventType) {
        switch (eventType) {
            case -13: 
            case -12: 
            case -11: 
            case -10: {
                return true;
            }
        }
        return false;
    }

    public static String timerEventName(Event event) {
        return TimerEvents.timerEventName(event.type());
    }

    public static String timerEventName(Frame frame) {
        return TimerEvents.timerEventName(frame.header().type());
    }

    public static String timerEventName(int eventType) {
        switch (eventType) {
            case -11: {
                return "TIMER_EXPIRED";
            }
            case -10: {
                return "TIMER_FIRED";
            }
            case -12: {
                return "TIMER_STARTED";
            }
            case -13: {
                return "TIMER_STOPPED";
            }
        }
        throw new IllegalArgumentException("Not a timer event type: " + eventType);
    }
}

