/*
 * Decompiled with CFR 0.152.
 */
package org.tools4j.elara.plugin.timer;

import java.util.Objects;
import org.tools4j.elara.application.EventApplier;
import org.tools4j.elara.event.Event;
import org.tools4j.elara.plugin.timer.TimerEvents;
import org.tools4j.elara.plugin.timer.TimerState;
import org.tools4j.elara.plugin.timer.TimerTriggerInput;

public class TimerEventApplier
implements EventApplier {
    private final TimerState.Mutable timerState;
    private final TimerTriggerInput timerTriggerInput;

    public TimerEventApplier(TimerState.Mutable timerState, TimerTriggerInput timerTriggerInput) {
        this.timerState = Objects.requireNonNull(timerState);
        this.timerTriggerInput = Objects.requireNonNull(timerTriggerInput);
    }

    @Override
    public void onEvent(Event event) {
        switch (event.type()) {
            case -12: {
                if (!this.timerState.add(TimerEvents.timerId(event), TimerEvents.timerType(event), TimerEvents.timerRepetition(event), event.time(), TimerEvents.timerTimeout(event))) break;
                this.timerTriggerInput.timerEventApplied();
                break;
            }
            case -10: {
                int index = this.timerState.indexById(TimerEvents.timerId(event));
                this.timerState.repetition(index, this.timerState.repetition(index) + 1);
                this.timerTriggerInput.timerEventApplied();
                break;
            }
            case -13: 
            case -11: {
                if (!this.timerState.removeById(TimerEvents.timerId(event))) break;
                this.timerTriggerInput.timerEventApplied();
            }
        }
    }
}

