/*
 * Decompiled with CFR 0.152.
 */
package org.tools4j.elara.plugin.timer;

import org.agrona.MutableDirectBuffer;
import org.tools4j.elara.command.Command;
import org.tools4j.elara.flyweight.Frame;
import org.tools4j.elara.plugin.timer.TimerPayloadDescriptor;

public enum TimerCommands {

    public static final int TRIGGER_TIMER = -10;

    public static int triggerTimer(MutableDirectBuffer buffer, int offset, long timerId, int timerType, int repetition, long timeout) {
        buffer.putLong(offset + 0, timerId);
        buffer.putInt(offset + 8, timerType);
        buffer.putInt(offset + 12, repetition);
        buffer.putLong(offset + 16, timeout);
        return 24;
    }

    public static long timerId(Command command) {
        return TimerPayloadDescriptor.timerId(command.payload());
    }

    public static int timerType(Command command) {
        return TimerPayloadDescriptor.timerType(command.payload());
    }

    public static int timerRepetition(Command command) {
        return TimerPayloadDescriptor.timerRepetition(command.payload());
    }

    public static long timerTimeout(Command command) {
        return TimerPayloadDescriptor.timerTimeout(command.payload());
    }

    public static boolean isTimerCommand(Command command) {
        return TimerCommands.isTimerCommandType(command.type());
    }

    public static boolean isTimerCommand(Frame frame) {
        return frame.header().index() < 0 && TimerCommands.isTimerCommandType(frame.header().type());
    }

    public static boolean isTimerCommandType(int commandType) {
        switch (commandType) {
            case -10: {
                return true;
            }
        }
        return false;
    }

    public static String timerCommandName(Command command) {
        return TimerCommands.timerCommandName(command.type());
    }

    public static String timerCommandName(Frame frame) {
        return TimerCommands.timerCommandName(frame.header().type());
    }

    public static String timerCommandName(int commandType) {
        switch (commandType) {
            case -10: {
                return "TRIGGER_TIMER";
            }
        }
        throw new IllegalArgumentException("Not a timer command type: " + commandType);
    }
}

