/*
 * Decompiled with CFR 0.152.
 */
package org.tools4j.elara.plugin.replication;

import java.util.LinkedHashSet;
import java.util.Objects;
import org.tools4j.elara.plugin.replication.Configuration;
import org.tools4j.elara.plugin.replication.Connection;
import org.tools4j.elara.plugin.replication.EnforceLeaderInput;
import org.tools4j.elara.plugin.replication.EnforcedLeaderEventReceiver;
import org.tools4j.elara.plugin.replication.EventSender;
import org.tools4j.elara.plugin.replication.ReplicationState;
import org.tools4j.nobark.loop.Step;

public class ReplicationPluginStep
implements Step {
    private final int serverId;
    private final int[] serverIds;
    private final ReplicationState.Volatile replicationState;
    private final EnforcedLeaderEventReceiver enforcedLeaderEventReceiver;
    private final Connection.Handler connectionHandler;
    private final EventSender eventSender;
    private final EnforceLeaderInput enforceLeaderInput;
    private final Connection.Poller[] connectionPollers;

    public ReplicationPluginStep(Configuration configuration, ReplicationState.Volatile replicationState, EnforcedLeaderEventReceiver enforcedLeaderEventReceiver, Connection.Handler connectionHandler, EventSender eventSender) {
        this.serverId = configuration.serverId();
        this.serverIds = configuration.serverIds();
        this.replicationState = Objects.requireNonNull(replicationState);
        this.enforcedLeaderEventReceiver = Objects.requireNonNull(enforcedLeaderEventReceiver);
        this.connectionHandler = Objects.requireNonNull(connectionHandler);
        this.eventSender = Objects.requireNonNull(eventSender);
        this.enforceLeaderInput = configuration.enforceLeaderInput();
        this.connectionPollers = this.initPollers(configuration);
    }

    public boolean perform() {
        boolean workDone = false;
        workDone |= this.pollEnforcedLeaderInput();
        workDone |= this.pollConnections();
        return workDone |= this.updateFollowers();
    }

    private boolean pollEnforcedLeaderInput() {
        return this.enforceLeaderInput.poll(this.enforcedLeaderEventReceiver) > 0;
    }

    private boolean pollConnections() {
        int polled = 0;
        for (Connection.Poller poller : this.connectionPollers) {
            polled += poller.poll(this.connectionHandler);
        }
        return polled > 0;
    }

    private boolean updateFollowers() {
        if (this.isLeader()) {
            boolean workDone = false;
            long eventLogSize = this.replicationState.eventLogSize();
            for (int server = 0; server < this.serverIds.length; server = (int)((short)(server + 1))) {
                int followerId = this.serverIds[server];
                if (followerId == this.serverId) continue;
                long nextEventLogIndex = this.replicationState.nextEventLogIndex(followerId);
                if (nextEventLogIndex < eventLogSize) {
                    if (this.eventSender.sendEvent(followerId, nextEventLogIndex)) {
                        this.replicationState.nextEventLogIndex(followerId, nextEventLogIndex + 1L);
                    }
                    workDone = true;
                    continue;
                }
                long confirmedEventLogIndex = this.replicationState.confirmedEventLogIndex(followerId);
                if (confirmedEventLogIndex >= eventLogSize) continue;
                long nanoTime = System.nanoTime();
                long nextTime = this.replicationState.nextNotBefore(followerId);
                if (nextTime != 0L && nanoTime - nextTime < 0L) continue;
                this.replicationState.nextEventLogIndex(followerId, confirmedEventLogIndex + 1L);
                this.replicationState.nextNotBefore(followerId, nanoTime + 10000L);
                workDone = true;
            }
            return workDone;
        }
        return false;
    }

    private boolean isLeader() {
        return this.serverId == this.replicationState.leaderId();
    }

    private Connection.Poller[] initPollers(Configuration configuration) {
        LinkedHashSet<Connection> connections = new LinkedHashSet<Connection>();
        for (int i = 0; i < this.serverIds.length; ++i) {
            connections.add(configuration.connection(this.serverIds[i]));
        }
        return (Connection.Poller[])connections.stream().map(Connection::poller).toArray(Connection.Poller[]::new);
    }
}

