/*
 * Decompiled with CFR 0.152.
 */
package org.tools4j.elara.plugin.replication;

import java.util.Objects;
import org.agrona.collections.IntHashSet;
import org.tools4j.elara.flyweight.FlyweightHeader;
import org.tools4j.elara.log.MessageLog;
import org.tools4j.elara.logging.ElaraLogger;
import org.tools4j.elara.logging.Logger;
import org.tools4j.elara.plugin.replication.Configuration;
import org.tools4j.elara.plugin.replication.EnforceLeaderInput;
import org.tools4j.elara.plugin.replication.ReplicationEvents;
import org.tools4j.elara.plugin.replication.ReplicationState;
import org.tools4j.elara.time.TimeSource;

final class EnforcedLeaderEventReceiver
implements EnforceLeaderInput.EnforceLeaderReceiver {
    private final ElaraLogger logger;
    private final TimeSource timeSource;
    private final int serverId;
    private final IntHashSet serverIds;
    private final ReplicationState state;
    private final MessageLog.Appender eventLogAppender;

    EnforcedLeaderEventReceiver(Logger.Factory loggerFactory, TimeSource timeSource, Configuration configuration, ReplicationState state, MessageLog.Appender eventLogAppender) {
        this.logger = ElaraLogger.create(loggerFactory, this.getClass());
        this.timeSource = Objects.requireNonNull(timeSource);
        this.serverIds = new IntHashSet(-1);
        this.state = Objects.requireNonNull(state);
        this.eventLogAppender = Objects.requireNonNull(eventLogAppender);
        this.serverId = configuration.serverId();
        for (int serverId : configuration.serverIds()) {
            this.serverIds.add(serverId);
        }
    }

    @Override
    public int serverId() {
        return this.serverId;
    }

    @Override
    public int currentTerm() {
        return this.state.currentTerm();
    }

    @Override
    public int leaderId() {
        return this.state.leaderId();
    }

    @Override
    public void enforceLeader(int source, long sequence, int leaderId) {
        if (!this.isValidLeaderId(leaderId)) {
            this.logger.warn("Server {}: Ignoring enforce-leader request {}:{} due to invalid leader ID {}").replace(this.serverId).replace(source).replace(sequence).replace(leaderId).format();
            return;
        }
        int nextTerm = 1 + this.state.currentTerm();
        try (MessageLog.AppendingContext context = this.eventLogAppender.appending();){
            FlyweightHeader.writeTo(source, -99, sequence, this.timeSource.currentTime(), (byte)1, (short)0, 16, context.buffer(), 0);
            ReplicationEvents.leaderEnforced(context.buffer(), 32, nextTerm, leaderId);
            context.commit(48);
        }
    }

    private boolean isValidLeaderId(int leaderId) {
        if (leaderId == this.state.leaderId()) {
            this.logger.warn("Server {}: Ignoring enforce-leader input: enforced leader {} is already the current leader").replace(this.serverId).replace(leaderId).format();
            return false;
        }
        if (!this.serverIds.contains(leaderId)) {
            this.logger.warn("Server {}: Ignoring enforce-leader input: server ID {} is invalid").replace(this.serverId).replace(leaderId).format();
            return false;
        }
        return true;
    }
}

