/*
 * Decompiled with CFR 0.152.
 */
package org.tools4j.elara.plugin.replication;

import org.agrona.collections.Long2LongHashMap;
import org.agrona.collections.LongArrayList;
import org.tools4j.elara.event.Event;
import org.tools4j.elara.plugin.replication.ReplicationState;

public class DefaultReplicationState
implements ReplicationState.Mutable {
    private int currentTerm;
    private int leaderId = -1;
    private long eventLogSize;
    private final Long2LongHashMap nextEventLogIndexByServerId = new Long2LongHashMap(0L);
    private final Long2LongHashMap confirmedEventLogIndexByServerId = new Long2LongHashMap(0L);
    private final Long2LongHashMap nextNotBefore = new Long2LongHashMap(0L);
    private final LongArrayList temp = new LongArrayList();

    @Override
    public int currentTerm() {
        return this.currentTerm;
    }

    @Override
    public ReplicationState.Mutable currentTerm(int term) {
        this.currentTerm = term;
        return this;
    }

    @Override
    public int leaderId() {
        return this.leaderId;
    }

    @Override
    public ReplicationState.Mutable leaderId(int leaderId) {
        this.leaderId = leaderId;
        return this;
    }

    @Override
    public long eventLogSize() {
        return this.eventLogSize;
    }

    @Override
    public ReplicationState.Mutable eventApplied(Event event) {
        ++this.eventLogSize;
        return this;
    }

    @Override
    public long nextEventLogIndex(int serverId) {
        return this.nextEventLogIndexByServerId.get((long)serverId);
    }

    @Override
    public ReplicationState.Volatile nextEventLogIndex(int serverId, long index) {
        DefaultReplicationState.putOrRemove(this.nextEventLogIndexByServerId, serverId, index);
        return this;
    }

    @Override
    public long confirmedEventLogIndex(int serverId) {
        return this.confirmedEventLogIndexByServerId.get((long)serverId);
    }

    @Override
    public ReplicationState.Volatile confirmedEventLogIndex(int serverId, long index) {
        DefaultReplicationState.putOrRemove(this.confirmedEventLogIndexByServerId, serverId, index);
        return this;
    }

    @Override
    public long committedEventLogIndex(int serverCount) {
        int majority = serverCount / 2 + 1;
        if (this.confirmedEventLogIndexByServerId.size() < majority) {
            return -1L;
        }
        this.temp.clear();
        Long2LongHashMap.ValueIterator it = this.confirmedEventLogIndexByServerId.values().iterator();
        while (it.hasNext()) {
            long value = it.nextValue();
            int index = this.temp.size();
            this.temp.addLong(value);
            while (index > 0 && value > this.temp.get(index - 1)) {
                this.temp.set(index, this.temp.get(index - 1));
            }
            this.temp.set(index, Long.valueOf(value));
        }
        return this.temp.get(majority - 1);
    }

    @Override
    public long nextNotBefore(int serverId) {
        return this.nextNotBefore.get((long)serverId);
    }

    @Override
    public ReplicationState.Volatile nextNotBefore(int serverId, long nanos) {
        DefaultReplicationState.putOrRemove(this.nextNotBefore, serverId, nanos);
        return this;
    }

    private static void putOrRemove(Long2LongHashMap map, long key, long value) {
        if (value == map.missingValue()) {
            map.remove(key);
        } else {
            map.put(key, value);
        }
    }

    public String toString() {
        return "DefaultReplicationState{currentTerm=" + this.currentTerm + ", leaderId=" + this.leaderId + ", eventLogSize=" + this.eventLogSize + ", nextEventLogIndexByServerId=" + this.nextEventLogIndexByServerId + ", nextNotBefore=" + this.nextNotBefore + '}';
    }
}

