/*
 * Decompiled with CFR 0.152.
 */
package org.tools4j.elara.plugin.replication;

import java.util.Objects;
import org.agrona.DirectBuffer;
import org.agrona.ExpandableDirectByteBuffer;
import org.agrona.MutableDirectBuffer;
import org.agrona.collections.Int2ObjectHashMap;
import org.tools4j.elara.log.IndexTrackingPoller;
import org.tools4j.elara.log.MessageLog;
import org.tools4j.elara.plugin.replication.Configuration;
import org.tools4j.elara.plugin.replication.Connection;
import org.tools4j.elara.plugin.replication.EventSender;
import org.tools4j.elara.plugin.replication.ReplicationMessages;
import org.tools4j.elara.plugin.replication.ReplicationState;

final class DefaultEventSender
implements EventSender {
    private final ReplicationState state;
    private final Connection.Publisher publisher;
    private final MutableDirectBuffer sendBuffer;
    private final Int2ObjectHashMap<IndexTrackingPoller> pollerByServerId = new Int2ObjectHashMap();
    private final PublishingHandler publishingHandler = new PublishingHandler();

    DefaultEventSender(Configuration configuration, ReplicationState state, MessageLog messageLog, Connection.Publisher publisher) {
        Objects.requireNonNull(configuration);
        this.state = Objects.requireNonNull(state);
        Objects.requireNonNull(messageLog);
        this.publisher = Objects.requireNonNull(publisher);
        this.sendBuffer = new ExpandableDirectByteBuffer(Math.max(32, configuration.initialSendBufferCapacity()));
        int currentServerId = configuration.serverId();
        for (int serverId : configuration.serverIds()) {
            if (serverId == currentServerId) continue;
            this.pollerByServerId.put(serverId, (Object)IndexTrackingPoller.create(messageLog));
        }
    }

    @Override
    public boolean sendEvent(int targetServerId, long eventLogIndex) {
        IndexTrackingPoller poller = (IndexTrackingPoller)this.pollerByServerId.get(targetServerId);
        if (poller == null) {
            throw new NullPointerException("No poller found for target server " + targetServerId);
        }
        long index = poller.index();
        if (index == eventLogIndex) {
            return poller.poll(this.publishingHandler.init(targetServerId, eventLogIndex)) > 0;
        }
        if (index < eventLogIndex) {
            poller.moveToNext();
        } else {
            poller.moveToPrevious();
        }
        return false;
    }

    private final class PublishingHandler
    implements MessageLog.Handler {
        int targetServerId = -1;
        long eventLogIndex = -1L;

        private PublishingHandler() {
        }

        PublishingHandler init(int targetServerId, long eventLogIndex) {
            this.targetServerId = targetServerId;
            this.eventLogIndex = eventLogIndex;
            return this;
        }

        @Override
        public MessageLog.Handler.Result onMessage(DirectBuffer message) {
            int length = ReplicationMessages.appendRequest(DefaultEventSender.this.sendBuffer, 0, DefaultEventSender.this.state.currentTerm(), DefaultEventSender.this.state.leaderId(), this.eventLogIndex, message, 0, message.capacity());
            if (DefaultEventSender.this.publisher.publish(this.targetServerId, (DirectBuffer)DefaultEventSender.this.sendBuffer, 0, length)) {
                return MessageLog.Handler.Result.POLL;
            }
            return MessageLog.Handler.Result.PEEK;
        }
    }
}

