/*
 * Decompiled with CFR 0.152.
 */
package org.tools4j.elara.plugin.replication;

import java.util.Objects;
import org.agrona.collections.Int2ObjectHashMap;
import org.agrona.collections.IntArrayList;
import org.agrona.collections.IntHashSet;
import org.tools4j.elara.plugin.replication.Configuration;
import org.tools4j.elara.plugin.replication.Connection;
import org.tools4j.elara.plugin.replication.Context;
import org.tools4j.elara.plugin.replication.EnforceLeaderInput;

final class DefaultContext
implements Context {
    public static final int DEFAULT_INITIAL_SEND_BUFFER_CAPACITY = 1024;
    private static final EnforceLeaderInput NULL_INPUT = receiver -> 0;
    private int serverId = -1;
    private final IntArrayList serverIds = new IntArrayList();
    private EnforceLeaderInput enforceLeaderInput = NULL_INPUT;
    private final Int2ObjectHashMap<Connection> connectionByServerId = new Int2ObjectHashMap();
    private int initialSendBufferCapacity = 1024;

    DefaultContext() {
    }

    @Override
    public int serverId() {
        return this.serverId;
    }

    @Override
    public int[] serverIds() {
        return this.serverIds.toIntArray();
    }

    @Override
    public Context serverId(int serverId) {
        return this.serverId(serverId, true);
    }

    @Override
    public Context serverId(int serverId, boolean local) {
        this.serverIds.addInt(serverId);
        if (local) {
            this.serverId = serverId;
        }
        return this;
    }

    @Override
    public Context serverIds(int ... serverIds) {
        for (int serverId : serverIds) {
            this.serverId(serverId, false);
        }
        return this;
    }

    @Override
    public EnforceLeaderInput enforceLeaderInput() {
        return this.enforceLeaderInput;
    }

    @Override
    public Context enforceLeaderInput(EnforceLeaderInput input) {
        this.enforceLeaderInput = Objects.requireNonNull(input);
        return this;
    }

    @Override
    public Connection connection(int serverId) {
        return (Connection)this.connectionByServerId.get(serverId);
    }

    @Override
    public Context connection(int serverId, Connection connection) {
        this.connectionByServerId.put(serverId, (Object)connection);
        return this;
    }

    @Override
    public int initialSendBufferCapacity() {
        return this.initialSendBufferCapacity;
    }

    @Override
    public Context initialSendBufferCapacity(int size) {
        this.initialSendBufferCapacity = size;
        return this;
    }

    static Configuration validate(Configuration configuration) {
        int localServerId = configuration.serverId();
        IntHashSet serverIds = new IntHashSet(-1);
        for (int serverId : configuration.serverIds()) {
            if (serverId == -1) {
                throw new IllegalArgumentException("Invalid server ID: " + serverId);
            }
            if (!serverIds.add(serverId)) {
                throw new IllegalArgumentException("Duplicate server ID: " + serverId);
            }
            if (serverId == localServerId || configuration.connection(serverId) != null) continue;
            throw new IllegalArgumentException("No connection defined for server ID: " + serverId);
        }
        if (!serverIds.contains(localServerId)) {
            throw new IllegalArgumentException("Server ID " + localServerId + " must be one of the server IDs " + serverIds);
        }
        return configuration;
    }
}

