/*
 * Decompiled with CFR 0.152.
 */
package org.tools4j.elara.plugin.metrics;

import java.util.Objects;
import org.agrona.MutableDirectBuffer;
import org.tools4j.elara.command.Command;
import org.tools4j.elara.event.Event;
import org.tools4j.elara.log.MessageLog;
import org.tools4j.elara.plugin.metrics.Configuration;
import org.tools4j.elara.plugin.metrics.FlyweightMetricsLogEntry;
import org.tools4j.elara.plugin.metrics.MetricsState;
import org.tools4j.elara.plugin.metrics.TimeMetric;
import org.tools4j.elara.time.TimeSource;

public class TimeMetricsLogger {
    private final TimeSource timeSource;
    private final Configuration configuration;
    private final MetricsState state;
    private final MessageLog.Appender appender;

    public TimeMetricsLogger(TimeSource timeSource, Configuration configuration, MetricsState state) {
        this.timeSource = Objects.requireNonNull(timeSource);
        this.configuration = Objects.requireNonNull(configuration);
        this.state = Objects.requireNonNull(state);
        if (configuration.timeMetrics().isEmpty()) {
            throw new IllegalArgumentException("Configuration contains no time metrics");
        }
        this.appender = Objects.requireNonNull(configuration.timeMetricsLog(), "configuration.timeMetricsLog()").appender();
    }

    public int logMetrics(Command command) {
        return this.logMetrics(TimeMetric.Target.COMMAND, command.id(), (short)Short.MIN_VALUE);
    }

    public int logMetrics(TimeMetric.Target target, Event event) {
        if (target == TimeMetric.Target.COMMAND) {
            throw new IllegalArgumentException("Command target not applicable for events");
        }
        Event.Id id = event.id();
        return this.logMetrics(target, id.commandId(), (short)id.index());
    }

    private int logMetrics(TimeMetric.Target target, Command.Id commandId, short index) {
        byte flags = target.flags(this.configuration.timeMetrics());
        int count = target.count(flags);
        if (count == 0) {
            return 0;
        }
        int source = commandId.source();
        long sequence = commandId.sequence();
        try (MessageLog.AppendingContext context = this.appender.appending();){
            int headerLen;
            MutableDirectBuffer buffer = context.buffer();
            int offset = headerLen = FlyweightMetricsLogEntry.writeTimeMetricsHeader(flags, index, source, sequence, this.timeSource.currentTime(), buffer, 0);
            for (int i = 0; i < count; ++i) {
                TimeMetric metric = target.metric(flags, i);
                long time = metric == TimeMetric.METRIC_APPENDING_TIME ? this.timeSource.currentTime() : this.state.time(metric);
                offset += FlyweightMetricsLogEntry.writeTime(time, buffer, offset);
                this.state.clear(metric);
            }
            int length = offset;
            context.commit(length);
        }
        return count;
    }
}

