/*
 * Decompiled with CFR 0.152.
 */
package org.tools4j.elara.plugin.metrics;

import org.agrona.DirectBuffer;

public enum MetricsDescriptor {

    public static final byte VERSION = 1;
    static final byte FLAGS_NONE = 0;
    public static final int VERSION_OFFSET = 0;
    public static final int VERSION_LENGTH = 1;
    public static final int FLAGS_OFFSET = 1;
    public static final int FLAGS_LENGTH = 1;
    public static final int INDEX_OFFSET = 2;
    public static final int INDEX_LENGTH = 2;
    public static final int SOURCE_OFFSET = 4;
    public static final int SOURCE_LENGTH = 4;
    public static final int SEQUENCE_OFFSET = 8;
    public static final int SEQUENCE_LENGTH = 8;
    public static final int TIME_OFFSET = 16;
    public static final int TIME_LENGTH = 8;
    public static final int CHOICE_OFFSET = 2;
    public static final int CHOICE_LENGTH = 2;
    public static final int REPETITION_OFFSET = 4;
    public static final int REPETITION_LENGTH = 4;
    public static final int INTERVAL_OFFSET = 8;
    public static final int INTERVAL_LENGTH = 8;
    public static final int HEADER_OFFSET = 0;
    public static final int HEADER_LENGTH = 24;
    public static final int PAYLOAD_OFFSET = 24;

    public static byte version(DirectBuffer buffer) {
        return buffer.getByte(0);
    }

    public static byte flags(DirectBuffer buffer) {
        return buffer.getByte(1);
    }

    public static boolean isTimeMetrics(DirectBuffer buffer) {
        return 0 != MetricsDescriptor.flags(buffer);
    }

    public static boolean isFrequencyMetrics(DirectBuffer buffer) {
        return 0 == MetricsDescriptor.flags(buffer);
    }

    public static short index(DirectBuffer buffer) {
        return buffer.getShort(2);
    }

    public static int source(DirectBuffer buffer) {
        return buffer.getInt(4);
    }

    public static long sequence(DirectBuffer buffer) {
        return buffer.getLong(8);
    }

    public static long time(DirectBuffer buffer) {
        return buffer.getLong(16);
    }

    public static short choice(DirectBuffer buffer) {
        return buffer.getShort(2);
    }

    public static int repetition(DirectBuffer buffer) {
        return buffer.getInt(4);
    }

    public static long interval(DirectBuffer buffer) {
        return buffer.getInt(8);
    }

    public static long time(int index, DirectBuffer buffer) {
        return buffer.getLong(24 + index * 8);
    }

    public static long counter(int index, DirectBuffer buffer) {
        return buffer.getLong(24 + index * 8);
    }
}

