/*
 * Decompiled with CFR 0.152.
 */
package org.tools4j.elara.plugin.metrics;

import java.util.EnumSet;
import java.util.Objects;
import java.util.Set;
import org.tools4j.elara.log.MessageLog;
import org.tools4j.elara.plugin.metrics.Configuration;
import org.tools4j.elara.plugin.metrics.Context;
import org.tools4j.elara.plugin.metrics.FrequencyMetric;
import org.tools4j.elara.plugin.metrics.InputSendingTimeExtractor;
import org.tools4j.elara.plugin.metrics.TimeMetric;

public class DefaultContext
implements Context {
    private final Set<TimeMetric> timeMetrics = EnumSet.noneOf(TimeMetric.class);
    private final Set<FrequencyMetric> frequencyMetrics = EnumSet.noneOf(FrequencyMetric.class);
    private InputSendingTimeExtractor inputSendingTimeExtractor;
    private long frequencyLogInterval;
    private MessageLog timeMetricsLog;
    private MessageLog frequencyMetricsLog;

    @Override
    public Set<TimeMetric> timeMetrics() {
        return this.timeMetrics;
    }

    @Override
    public Set<FrequencyMetric> frequencyMetrics() {
        return this.frequencyMetrics;
    }

    @Override
    public InputSendingTimeExtractor inputSendingTimeExtractor() {
        return this.inputSendingTimeExtractor;
    }

    @Override
    public long frequencyLogInterval() {
        return this.frequencyLogInterval;
    }

    @Override
    public MessageLog timeMetricsLog() {
        return this.timeMetricsLog;
    }

    @Override
    public MessageLog frequencyMetricsLog() {
        return this.frequencyMetricsLog;
    }

    @Override
    public Context timeMetric(TimeMetric metric) {
        this.timeMetrics.add(metric);
        return this;
    }

    @Override
    public Context timeMetrics(TimeMetric ... metrics) {
        for (TimeMetric metric : metrics) {
            this.timeMetrics.add(metric);
        }
        return this;
    }

    @Override
    public Context timeMetrics(Set<? extends TimeMetric> metrics) {
        this.timeMetrics.addAll(metrics);
        return this;
    }

    @Override
    public Context frequencyMetric(FrequencyMetric metric) {
        this.frequencyMetrics.add(metric);
        return this;
    }

    @Override
    public Context frequencyMetrics(FrequencyMetric ... metrics) {
        for (FrequencyMetric metric : metrics) {
            this.frequencyMetrics.add(metric);
        }
        return this;
    }

    @Override
    public Context frequencyMetrics(Set<? extends FrequencyMetric> metrics) {
        this.frequencyMetrics.addAll(metrics);
        return this;
    }

    @Override
    public Context inputSendingTimeExtractor(InputSendingTimeExtractor sendingTimeExtractor) {
        this.inputSendingTimeExtractor = Objects.requireNonNull(sendingTimeExtractor);
        return this;
    }

    @Override
    public Context frequencyLogInterval(long timeInterval) {
        if (timeInterval <= 0L) {
            throw new IllegalArgumentException("time interval must be positive: " + timeInterval);
        }
        this.frequencyLogInterval = timeInterval;
        return this;
    }

    @Override
    public Context metricsLog(MessageLog metricLog) {
        Objects.requireNonNull(metricLog);
        this.timeMetricsLog = metricLog;
        this.frequencyMetricsLog = metricLog;
        return this;
    }

    @Override
    public Context timeMetricsLog(MessageLog metricLog) {
        this.timeMetricsLog = Objects.requireNonNull(metricLog);
        return this;
    }

    @Override
    public Context frequencyMetricsLog(MessageLog metricLog) {
        this.frequencyMetricsLog = Objects.requireNonNull(metricLog);
        return this;
    }

    static Configuration validate(Configuration configuration) {
        if (configuration.timeMetrics().isEmpty() && configuration.frequencyMetrics().isEmpty()) {
            throw new IllegalArgumentException("No time or frequency metrics are specified in the metrics plugin configuration");
        }
        if (configuration.timeMetrics().contains((Object)TimeMetric.INPUT_SENDING_TIME) && null == configuration.inputSendingTimeExtractor()) {
            throw new IllegalArgumentException("Metrics configuration specifies to capture " + (Object)((Object)TimeMetric.INPUT_SENDING_TIME) + " but no " + InputSendingTimeExtractor.class.getSimpleName() + " is configured");
        }
        if (!configuration.frequencyMetrics().isEmpty() && 0L == configuration.frequencyLogInterval()) {
            throw new IllegalArgumentException("Metrics configuration specifies at least one frequency metric but no frequency log interval is configured");
        }
        if (!configuration.timeMetrics().isEmpty() && null == configuration.timeMetricsLog()) {
            throw new IllegalArgumentException("Metrics configuration specifies at least one time metric but no time metric log is configured");
        }
        if (!configuration.frequencyMetrics().isEmpty() && null == configuration.frequencyMetricsLog()) {
            throw new IllegalArgumentException("Metrics configuration specifies at least one frequency metric but no frequency metric log is configured");
        }
        return configuration;
    }
}

