/*
 * Decompiled with CFR 0.152.
 */
package org.tools4j.elara.plugin.boot;

import org.tools4j.elara.event.Event;
import org.tools4j.elara.flyweight.Frame;

public enum BootEvents {

    public static final int APP_INITIALISATION_STARTED = -20;
    public static final int APP_INITIALISATION_COMPLETED = -21;

    public static boolean isBootEvent(Event event) {
        return BootEvents.isBootEvent(event.type());
    }

    public static boolean isBootEvent(Frame frame) {
        return frame.header().index() >= 0 && BootEvents.isBootEvent(frame.header().type());
    }

    public static boolean isBootEvent(int eventType) {
        switch (eventType) {
            case -21: 
            case -20: {
                return true;
            }
        }
        return false;
    }

    public static String bootEventName(Event event) {
        return BootEvents.bootEventName(event.type());
    }

    public static String bootEventName(Frame frame) {
        return BootEvents.bootEventName(frame.header().type());
    }

    public static String bootEventName(int eventType) {
        switch (eventType) {
            case -20: {
                return "APP_INITIALISATION_STARTED";
            }
            case -21: {
                return "APP_INITIALISATION_COMPLETED";
            }
        }
        throw new IllegalArgumentException("Not a boot event type: " + eventType);
    }
}

