/*
 * Decompiled with CFR 0.152.
 */
package org.tools4j.elara.plugin.base;

import org.agrona.collections.Long2ObjectHashMap;
import org.tools4j.elara.command.Command;
import org.tools4j.elara.event.Event;
import org.tools4j.elara.plugin.base.BaseState;

public class DefaultBaseState
implements BaseState.Mutable {
    private final Long2ObjectHashMap<AppliedEventState> sourceToAppliedEventState = new Long2ObjectHashMap();
    private boolean processCommands;

    public DefaultBaseState() {
        this(true);
    }

    public DefaultBaseState(boolean processCommands) {
        this.processCommands = processCommands;
    }

    @Override
    public boolean processCommands() {
        return this.processCommands;
    }

    @Override
    public BaseState.Mutable processCommands(boolean newValue) {
        this.processCommands = newValue;
        return this;
    }

    @Override
    public boolean allEventsAppliedFor(Command.Id id) {
        AppliedEventState appliedEventState = (AppliedEventState)this.sourceToAppliedEventState.get((long)id.source());
        if (appliedEventState != null) {
            long sequence = id.sequence();
            return sequence < appliedEventState.sequence || sequence == appliedEventState.sequence && appliedEventState.isFinal;
        }
        return false;
    }

    @Override
    public boolean eventApplied(Event.Id id) {
        Command.Id cid = id.commandId();
        AppliedEventState appliedEventState = (AppliedEventState)this.sourceToAppliedEventState.get((long)cid.source());
        if (appliedEventState != null) {
            long sequence = cid.sequence();
            return sequence < appliedEventState.sequence || sequence == appliedEventState.sequence && id.index() <= appliedEventState.index;
        }
        return false;
    }

    @Override
    public BaseState.Mutable eventApplied(Event event) {
        ((AppliedEventState)this.sourceToAppliedEventState.computeIfAbsent((long)event.id().commandId().source(), k -> new AppliedEventState())).update(event);
        return this;
    }

    private static final class AppliedEventState {
        long sequence;
        int index;
        boolean isFinal;

        private AppliedEventState() {
        }

        void update(Event event) {
            Event.Id id = event.id();
            this.sequence = id.commandId().sequence();
            this.index = id.index();
            this.isFinal = event.flags().isFinal();
        }
    }
}

