/*
 * Decompiled with CFR 0.152.
 */
package org.tools4j.elara.plugin.base;

import java.io.IOException;
import java.util.Objects;
import org.tools4j.elara.init.Configuration;
import org.tools4j.elara.log.EventLogRepairer;
import org.tools4j.elara.log.MessageLog;
import org.tools4j.elara.plugin.api.Plugin;
import org.tools4j.elara.plugin.api.SystemPlugin;
import org.tools4j.elara.plugin.api.TypeRange;
import org.tools4j.elara.plugin.base.BaseState;
import org.tools4j.elara.plugin.base.DefaultBaseState;

public enum BasePlugin implements SystemPlugin<BaseState.Mutable>
{
    INSTANCE;


    @Override
    public BaseState.Mutable defaultPluginState() {
        return BaseConfiguration.createDefaultBaseState();
    }

    public BaseConfiguration configuration(Configuration appConfig, BaseState.Mutable baseState) {
        Objects.requireNonNull(appConfig);
        Objects.requireNonNull(baseState);
        if (baseState.processCommands()) {
            this.repairEventLogIfNeeded(appConfig);
        }
        return () -> baseState;
    }

    @Override
    public TypeRange typeRange() {
        return TypeRange.BASE;
    }

    private void repairEventLogIfNeeded(Configuration appConfig) {
        MessageLog eventLog = appConfig.eventLog();
        EventLogRepairer eventLogRepairer = new EventLogRepairer(eventLog);
        if (eventLogRepairer.isCorrupted()) {
            appConfig.exceptionHandler().handleException("Repairing corrupted event log", new IOException("Corrupted event log: " + eventLog));
            eventLogRepairer.repair();
        }
    }

    @FunctionalInterface
    public static interface BaseConfiguration
    extends Plugin.Configuration.Default {
        public static BaseState.Mutable createDefaultBaseState() {
            return new DefaultBaseState();
        }

        public BaseState.Mutable baseState();
    }
}

