/*
 * Decompiled with CFR 0.152.
 */
package org.tools4j.elara.plugin.base;

import org.agrona.DirectBuffer;
import org.agrona.MutableDirectBuffer;
import org.agrona.concurrent.UnsafeBuffer;
import org.tools4j.elara.event.Event;
import org.tools4j.elara.flyweight.FlyweightEvent;
import org.tools4j.elara.flyweight.Frame;

public enum BaseEvents {

    private static final DirectBuffer EMPTY_BUFFER = new UnsafeBuffer(0L, 0);

    public static FlyweightEvent commit(FlyweightEvent flyweightEvent, MutableDirectBuffer headerBuffer, int offset, int source, long sequence, short index, long time) {
        return BaseEvents.empty(flyweightEvent, headerBuffer, offset, source, sequence, index, -1, time, (byte)1);
    }

    public static FlyweightEvent rollback(FlyweightEvent flyweightEvent, MutableDirectBuffer headerBuffer, int offset, int source, long sequence, short index, long time) {
        return BaseEvents.empty(flyweightEvent, headerBuffer, offset, source, sequence, index, -2, time, (byte)2);
    }

    public static FlyweightEvent empty(FlyweightEvent flyweightEvent, MutableDirectBuffer headerBuffer, int offset, int source, long sequence, short index, int type, long time, byte flags) {
        return flyweightEvent.init(headerBuffer, offset, source, sequence, index, type, time, flags, EMPTY_BUFFER, 0, 0);
    }

    public static boolean isBaseEvent(Event event) {
        return BaseEvents.isBaseEventType(event.type());
    }

    public static boolean isBaseEvent(Frame frame) {
        return frame.header().index() >= 0 && BaseEvents.isBaseEventType(frame.header().type());
    }

    public static boolean isBaseEventType(int eventType) {
        switch (eventType) {
            case -2: 
            case -1: 
            case 0: {
                return true;
            }
        }
        return false;
    }

    public static String baseEventName(Event event) {
        return BaseEvents.baseEventName(event.type());
    }

    public static String baseEventName(Frame frame) {
        return BaseEvents.baseEventName(frame.header().type());
    }

    public static String baseEventName(int eventType) {
        switch (eventType) {
            case 0: {
                return "APPLICATION";
            }
            case -1: {
                return "COMMIT";
            }
            case -2: {
                return "ROLLBACK";
            }
        }
        throw new IllegalArgumentException("Not a base event type: " + eventType);
    }

    public static char baseEventCode(Event event) {
        return BaseEvents.baseEventCode(event.type());
    }

    public static char baseEventCode(Frame frame) {
        return BaseEvents.baseEventCode(frame.header().type());
    }

    public static char baseEventCode(int eventType) {
        switch (eventType) {
            case 0: {
                return 'A';
            }
            case -1: {
                return 'C';
            }
            case -2: {
                return 'R';
            }
        }
        throw new IllegalArgumentException("Not a base event type: " + eventType);
    }
}

