/*
 * Decompiled with CFR 0.152.
 */
package org.tools4j.elara.output;

import java.util.Objects;
import org.tools4j.elara.application.ExceptionHandler;
import org.tools4j.elara.event.Event;
import org.tools4j.elara.output.CommandLoopback;
import org.tools4j.elara.output.Output;

public class CompositeOutput
implements Output {
    private final Output[] outputs;
    private final ExceptionHandler exceptionHandler;

    public CompositeOutput(Output[] outputs, ExceptionHandler exceptionHandler) {
        this.outputs = Objects.requireNonNull(outputs);
        this.exceptionHandler = Objects.requireNonNull(exceptionHandler);
    }

    @Override
    public Output.Ack publish(Event event, boolean replay, int retry, CommandLoopback loopback) {
        Output.Ack ack = Output.Ack.COMMIT;
        for (Output output : this.outputs) {
            try {
                if (Output.Ack.RETRY != output.publish(event, replay, retry, loopback)) continue;
                ack = Output.Ack.RETRY;
            }
            catch (Throwable t) {
                this.exceptionHandler.handleEventOutputException(event, t);
            }
        }
        return ack;
    }
}

