/*
 * Decompiled with CFR 0.152.
 */
package org.tools4j.elara.loop;

import java.util.Objects;
import org.tools4j.elara.input.Input;
import org.tools4j.elara.input.Receiver;
import org.tools4j.nobark.loop.Step;

public final class SequencerStep
implements Step {
    private final Receiver receiver;
    private final Input[] inputs;
    private int roundRobinIndex = 0;

    public SequencerStep(Receiver receiver, Input ... inputs) {
        this.receiver = Objects.requireNonNull(receiver);
        this.inputs = Objects.requireNonNull(inputs);
    }

    public boolean perform() {
        int count = this.inputs.length;
        for (int i = 0; i < count; ++i) {
            int index = this.getAndIncrementRoundRobinIndex(count);
            if (this.inputs[index].poll(this.receiver) <= 0) continue;
            return true;
        }
        return false;
    }

    private int getAndIncrementRoundRobinIndex(int count) {
        int index = this.roundRobinIndex++;
        if (this.roundRobinIndex >= count) {
            this.roundRobinIndex = 0;
        }
        return index;
    }
}

