/*
 * Decompiled with CFR 0.152.
 */
package org.tools4j.elara.loop;

import java.util.Objects;
import org.agrona.DirectBuffer;
import org.tools4j.elara.flyweight.FlyweightEvent;
import org.tools4j.elara.handler.EventHandler;
import org.tools4j.elara.log.MessageLog;
import org.tools4j.nobark.loop.Step;

public class EventPollerStep
implements Step {
    private final MessageLog.Poller eventPoller;
    private final EventHandler eventHandler;
    private final MessageLog.Handler pollerHandler = this::onEvent;
    private final FlyweightEvent flyweightEvent = new FlyweightEvent();

    public EventPollerStep(MessageLog.Poller eventPoller, EventHandler eventHandler) {
        this.eventPoller = Objects.requireNonNull(eventPoller);
        this.eventHandler = Objects.requireNonNull(eventHandler);
    }

    public boolean perform() {
        return this.eventPoller.poll(this.pollerHandler) > 0;
    }

    private MessageLog.Handler.Result onEvent(DirectBuffer event) {
        this.eventHandler.onEvent(this.flyweightEvent.init(event, 0));
        return MessageLog.Handler.Result.POLL;
    }
}

